/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.gitools.persistence.FileFormat;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;

public class SaveFilePage
extends AbstractWizardPage {
    private FileFormat[] formats;
    private JButton browseFileBtn;
    private JButton browseFolderBtn;
    private JTextField fileName;
    private JTextField folder;
    private JComboBox format;
    private JLabel formatLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JTextField path;

    public SaveFilePage() {
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Save.png", (int)96));
        this.initComponents();
        this.fileName.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                SaveFilePage.this.setComplete(!SaveFilePage.this.fileName.getText().isEmpty());
                SaveFilePage.this.updateGeneratedFile();
            }
        });
        this.folder.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                SaveFilePage.this.updateGeneratedFile();
            }
        });
        this.format.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveFilePage.this.updateGeneratedFile();
            }
        });
    }

    private void updateGeneratedFile() {
        File file = this.getPathAsFile();
        String fn = file.getAbsolutePath();
        this.path.setText(fn);
        if (this.isComplete() && file.exists()) {
            this.setMessage(MessageStatus.WARN, "File " + file.getName() + " already exists");
        } else {
            this.setMessage(MessageStatus.INFO, "");
        }
        FileFormat fmt = this.getFormat();
        if (this.formats != null && this.formats.length > 1 && fmt != null && !fmt.checkExtension(fn)) {
            this.setMessage(MessageStatus.WARN, "The file extension doesn't match the selected format");
        }
    }

    public JComponent createControls() {
        return this;
    }

    public String getFileNameWithoutExtension() {
        return this.fileName.getText();
    }

    public void setFileNameWithoutExtension(String name) {
        this.fileName.setText(name);
    }

    public String getFolder() {
        return this.folder.getText();
    }

    public void setFolder(String folderPath) {
        this.folder.setText(folderPath);
    }

    public void setFormats(FileFormat[] formats) {
        this.formats = formats;
        this.format.setModel(new DefaultComboBoxModel<FileFormat>(formats));
        this.updateGeneratedFile();
    }

    public FileFormat getFormat() {
        return (FileFormat)this.format.getSelectedItem();
    }

    public void setFormatsVisible(boolean visible) {
        this.formatLabel.setVisible(visible);
        this.format.setVisible(visible);
    }

    public String getFileName() {
        StringBuilder sb = new StringBuilder();
        String name = this.getFileNameWithoutExtension();
        sb.append(name);
        File file = new File(name);
        String ext = FileChooserUtils.getExtension(file);
        if (!name.isEmpty() && ext == null && this.format.getSelectedIndex() >= 0) {
            FileFormat fmt = (FileFormat)this.format.getSelectedItem();
            if (!name.endsWith(".")) {
                sb.append('.');
            }
            sb.append(fmt.getExtension());
        }
        return sb.toString();
    }

    public String getPath() {
        return this.getPathAsFile().getAbsolutePath();
    }

    public File getPathAsFile() {
        String folderName = this.folder.getText();
        if (folderName.isEmpty()) {
            folderName = System.getProperty("user.dir");
        }
        return new File(folderName, this.getFileName());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fileName = new JTextField();
        this.browseFolderBtn = new JButton();
        this.jLabel2 = new JLabel();
        this.folder = new JTextField();
        this.formatLabel = new JLabel();
        this.format = new JComboBox();
        this.jLabel4 = new JLabel();
        this.path = new JTextField();
        this.browseFileBtn = new JButton();
        this.jLabel1.setText("Name");
        this.fileName.setFocusCycleRoot(true);
        this.browseFolderBtn.setText("Browse...");
        this.browseFolderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveFilePage.this.browseFolderBtnActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Folder");
        this.formatLabel.setText("Format");
        this.jLabel4.setText("Generated file");
        this.path.setEditable(false);
        this.browseFileBtn.setText("Browse...");
        this.browseFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveFilePage.this.browseFileBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.formatLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.format, 0, 396, Short.MAX_VALUE).addComponent(this.fileName, -1, 396, Short.MAX_VALUE).addComponent(this.folder, -1, 396, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.browseFolderBtn).addComponent(this.browseFileBtn))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.path, -1, 428, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fileName, -2, -1, -2).addComponent(this.browseFileBtn)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.folder, -2, -1, -2).addComponent(this.browseFolderBtn)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatLabel).addComponent(this.format, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.path, -2, -1, -2)).addContainerGap(241, Short.MAX_VALUE)));
    }

    private void browseFolderBtnActionPerformed(ActionEvent evt) {
        File selPath = FileChooserUtils.selectPath("Select folder", this.folder.getText());
        if (selPath != null) {
            this.folder.setText(selPath.getAbsolutePath());
        }
    }

    private void browseFileBtnActionPerformed(ActionEvent evt) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (FileFormat fmt : SaveFilePage.this.formats) {
                    if (!fmt.checkExtension(f.getName())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("Supported formats");
                if (SaveFilePage.this.formats != null && SaveFilePage.this.formats.length > 0) {
                    sb.append(" (*.").append(SaveFilePage.this.formats[0].getExtension());
                    for (int i = 1; i < SaveFilePage.this.formats.length; ++i) {
                        sb.append(", *.").append(SaveFilePage.this.formats[i].getExtension());
                    }
                    sb.append(')');
                }
                return sb.toString();
            }
        };
        FileChooserUtils.FileAndFilter sel = FileChooserUtils.selectFile("Select file", this.folder.getText(), 2, new FileFilter[]{ff});
        if (sel != null) {
            File selFile = sel.getFile();
            String fn = selFile.getName();
            this.fileName.setText(fn);
            this.folder.setText(selFile.getParentFile().getAbsolutePath());
            for (FileFormat f : this.formats) {
                if (!f.checkExtension(fn)) continue;
                this.format.setSelectedItem(f);
            }
        }
    }
}

