/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class PatternSourcePage
extends AbstractWizardPage {
    private AnnotationMatrix am;
    private boolean idOptVisible;
    private JList annList;
    private JRadioButton annOpt;
    private JComboBox annSepCb;
    private JLabel annSepLabel;
    private JRadioButton idOpt;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ButtonGroup optGroup;
    private JRadioButton patOpt;
    private JTextField patText;

    public PatternSourcePage(boolean idOptVisible) {
        this(null, idOptVisible);
    }

    public PatternSourcePage(AnnotationMatrix am, boolean idOptVisible) {
        this.am = am;
        this.idOptVisible = idOptVisible;
        this.initComponents();
        ChangeListener optListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PatternSourcePage.this.sourceChanged();
            }
        };
        this.idOpt.addChangeListener(optListener);
        this.annOpt.addChangeListener(optListener);
        this.patOpt.addChangeListener(optListener);
        this.annList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PatternSourcePage.this.annListChanged();
            }
        });
        this.annSepCb.setModel(new DefaultComboBoxModel<String>(new String[]{", ", "-", " | ", " / ", " > ", "::"}));
        this.annSepCb.setSelectedIndex(0);
        this.patText.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                PatternSourcePage.this.updateComplete();
            }
        });
        this.setTitle("Annotations selection");
        this.setComplete(true);
    }

    public void updateControls() {
        super.updateControls();
        if (this.am != null && this.am.getColumnCount() > 0) {
            this.annOpt.setSelected(true);
            DefaultListModel<String> model = new DefaultListModel<String>();
            if (this.idOptVisible) {
                model.addElement("id");
            }
            for (int i = 0; i < this.am.getColumnCount(); ++i) {
                model.addElement(this.am.getColumnLabel(i));
            }
            this.annList.setModel(model);
            this.annList.setSelectedIndex(0);
        } else {
            if (this.idOptVisible) {
                this.idOpt.setSelected(true);
            } else {
                this.patOpt.setSelected(true);
            }
            this.annOpt.setEnabled(false);
        }
    }

    private void updateComplete() {
        this.setComplete(this.annOpt.isSelected() && this.annList.getSelectedIndices().length > 0 || this.patOpt.isSelected() && this.patText.getDocument().getLength() > 0);
    }

    private void sourceChanged() {
        boolean annSel = this.annOpt.isSelected();
        this.annList.setEnabled(annSel);
        this.annSepLabel.setEnabled(annSel);
        this.annSepCb.setEnabled(annSel);
        this.patText.setEnabled(this.patOpt.isSelected());
    }

    private void annListChanged() {
        this.patText.setText(this.getPattern());
        this.updateComplete();
    }

    public String getPattern() {
        if (this.idOpt.isSelected()) {
            return "${id}";
        }
        if (this.patOpt.isSelected()) {
            return this.patText.getText();
        }
        StringBuilder sb = new StringBuilder();
        Object[] values = this.annList.getSelectedValues();
        if (values.length == 0) {
            return "";
        }
        sb.append("${");
        sb.append(values[0]);
        sb.append("}");
        for (int i = 1; i < values.length; ++i) {
            sb.append(this.annSepCb.getSelectedItem());
            sb.append("${");
            sb.append(values[i]);
            sb.append("}");
        }
        return sb.toString();
    }

    public String getPatternTitle() {
        if (this.idOpt.isSelected()) {
            return "id";
        }
        if (this.patOpt.isSelected()) {
            return this.patText.getText();
        }
        StringBuilder sb = new StringBuilder();
        Object[] values = this.annList.getSelectedValues();
        sb.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.append(this.annSepCb.getSelectedItem());
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public void setAnnotationMatrix(AnnotationMatrix am) {
        this.am = am;
        this.updateControls();
    }

    public boolean isIdOptVisible() {
        return this.idOptVisible;
    }

    public void setIdOptVisible(boolean idOptVisible) {
        this.idOptVisible = idOptVisible;
        this.idOpt.setVisible(idOptVisible);
        this.invalidate();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.annOpt = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.annList = new JList();
        this.patOpt = new JRadioButton();
        this.patText = new JTextField();
        this.jLabel1 = new JLabel();
        this.annSepLabel = new JLabel();
        this.annSepCb = new JComboBox();
        this.idOpt = new JRadioButton();
        this.optGroup.add(this.annOpt);
        this.annOpt.setText("Annotations");
        this.jScrollPane1.setViewportView(this.annList);
        this.optGroup.add(this.patOpt);
        this.patOpt.setText("Pattern");
        this.patText.setText("${id}");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 2.0f));
        this.jLabel1.setText("Press Ctrl key to select for multiple annotations");
        this.annSepLabel.setText("Separator");
        this.annSepCb.setEditable(true);
        this.optGroup.add(this.idOpt);
        this.idOpt.setText("Identifiers");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jScrollPane1, -1, 564, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.annSepLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annSepCb, -2, 125, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.patOpt)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.idOpt)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annOpt)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.patText, -1, 564, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.idOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.annSepLabel).addComponent(this.annSepCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.patOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patText, -2, -1, -2).addContainerGap()));
    }
}

