/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gitools.ui.utils.DocumentChangeListener;

public abstract class FilteredTreePanel
extends JPanel {
    private String lastFilterText = "";
    public JButton clearBtn;
    public JButton collapseBtn;
    public JButton expandBtn;
    public JTextField filterField;
    private JScrollPane jScrollPane1;
    public JTree tree;

    public FilteredTreePanel() {
        this.initComponents();
        this.filterField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                FilteredTreePanel.this.updateFilter();
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredTreePanel.this.filterField.setText("");
                FilteredTreePanel.this.filterField.requestFocusInWindow();
            }
        });
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredTreePanel.this.expandAll();
            }
        });
        this.collapseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredTreePanel.this.collapseAll();
            }
        });
        this.updateFilter();
    }

    private void updateFilter() {
        String filterText = this.getFilterText();
        this.clearBtn.setEnabled(!filterText.isEmpty());
        if (!filterText.equalsIgnoreCase(this.lastFilterText)) {
            this.lastFilterText = filterText;
            this.tree.setModel(this.updateModel(this.getFilterText()));
            this.expandAll();
        }
    }

    protected abstract TreeModel updateModel(String var1);

    private String getFilterText() {
        return this.filterField.getText();
    }

    public TreeModel getModel() {
        return this.tree.getModel();
    }

    public void setModel(TreeModel model) {
        this.tree.setModel(model);
        this.updateExpandCollapseButtons();
    }

    private void updateExpandCollapseButtons() {
        boolean enabled = false;
        TreeModel model = this.tree.getModel();
        if (model != null) {
            enabled = model.getRoot() != null;
        }
        this.expandBtn.setEnabled(enabled);
        this.collapseBtn.setEnabled(enabled);
    }

    public void expandCollapse(JTree tree, boolean expand) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return;
        }
        TreeNode root = (TreeNode)model.getRoot();
        this.expandCollapse(tree, new TreePath(root), expand);
        if (!tree.isRootVisible() && !expand) {
            tree.expandPath(new TreePath(root));
        }
    }

    private void expandCollapse(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandCollapse(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void expandAll() {
        this.expandCollapse(this.tree, true);
        this.filterField.requestFocusInWindow();
    }

    public void collapseAll() {
        this.expandCollapse(this.tree, false);
        this.filterField.requestFocusInWindow();
    }

    private void initComponents() {
        this.filterField = new JTextField();
        this.clearBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.collapseBtn = new JButton();
        this.expandBtn = new JButton();
        this.filterField.setFocusCycleRoot(true);
        this.clearBtn.setText("Clear");
        this.tree.setModel(null);
        this.jScrollPane1.setViewportView(this.tree);
        this.collapseBtn.setText("Collapse all");
        this.expandBtn.setText("Expand all");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 378, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.filterField, -1, 327, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearBtn)).addGroup(layout.createSequentialGroup().addComponent(this.expandBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collapseBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearBtn).addComponent(this.filterField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 159, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collapseBtn).addComponent(this.expandBtn)).addContainerGap()));
    }
}

