/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.ui.utils.DocumentChangeListener;

public class FilteredListPanel
extends JPanel {
    private static final long serialVersionUID = -513470999308628358L;
    private String lastFilterText = "";
    private Object[] listData;
    public JButton clearBtn;
    public JTextField filterField;
    private JScrollPane jScrollPane1;
    public JList list;

    public FilteredListPanel() {
        this.initComponents();
        this.initEvents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.filterField = new JTextField();
        this.clearBtn = new JButton();
        this.list.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.list);
        this.clearBtn.setText("Clear");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 379, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.filterField, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearBtn).addComponent(this.filterField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addContainerGap()));
    }

    private void initEvents() {
        this.filterField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                FilteredListPanel.this.updateFilter();
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredListPanel.this.filterField.setText("");
                FilteredListPanel.this.filterField.requestFocusInWindow();
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FilteredListPanel.this.selectionChanged();
            }
        });
    }

    private void updateFilter() {
        String filterText = this.getFilterText();
        this.clearBtn.setEnabled(!filterText.isEmpty());
        if (!filterText.equalsIgnoreCase(this.lastFilterText)) {
            this.lastFilterText = filterText;
            this.list.setModel(this.createListModel(this.listData, this.getFilterText()));
        }
    }

    public String getFilterText() {
        return this.filterField.getText();
    }

    public void resetFilterText() {
        this.filterField.setText("");
        this.filterField.requestFocusInWindow();
    }

    private ListModel createListModel(Object[] listData, String filterText) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        if (filterText != null && !filterText.isEmpty()) {
            String filter = filterText.toLowerCase();
            for (Object dataObject : listData) {
                String dataText = dataObject.toString().toLowerCase();
                if (!dataText.contains(filter)) continue;
                model.addElement(dataObject);
            }
        } else {
            for (Object dataObject : listData) {
                model.addElement(dataObject);
            }
        }
        return model;
    }

    protected void selectionChanged() {
    }

    public void setListData(Object[] listData) {
        this.listData = listData;
        ListModel model = this.createListModel(listData, this.getFilterText());
        this.list.setModel(model);
        this.selectionChanged();
        this.filterField.requestFocusInWindow();
    }

    public void setSelectionMode(int mode) {
        this.list.setSelectionMode(mode);
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public void setSElectedValue(Object o) {
        this.list.setSelectedValue(o, true);
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }
}

