/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class FileChooserPage
extends AbstractWizardPage {
    private int selectionMode;
    private File currentPath;
    private File selectedFile;
    private JFileChooser fileChooser;

    public FileChooserPage() {
        this(0);
    }

    public FileChooserPage(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public JComponent createControls() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileSelectionMode(this.selectionMode);
        if (this.currentPath != null) {
            this.fileChooser.setCurrentDirectory(this.currentPath);
        }
        if (this.selectedFile != null) {
            this.fileChooser.setSelectedFile(this.selectedFile);
        }
        this.updateComplete();
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("SelectedFileChangedProperty".equals(evt.getPropertyName()) || "SelectedFilesChangedProperty".equals(evt.getPropertyName())) {
                    FileChooserPage.this.updateComplete();
                }
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.fileChooser, "Center");
        return p;
    }

    private void updateComplete() {
        this.setComplete(this.fileChooser.getSelectedFile() != null || this.fileChooser.getSelectedFiles().length > 0);
    }

    public void setFileSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setCurrentPath(File file) {
        this.currentPath = file;
    }

    public void setSelectedFile(File file) {
        this.selectedFile = file;
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public File[] getSelectedFiles() {
        return this.fileChooser.getSelectedFiles();
    }
}

