/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.wizard.common;

import org.gitools.heatmap.Heatmap;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.ExportHeatmapLabelsPage;
import org.gitools.ui.wizard.common.PatternSourcePage;
import org.gitools.ui.wizard.common.SaveFilePage;

public class ExportHeatmapLabelsWizard
extends AbstractWizard {
    private FileFormat[] supportedFormats = new FileFormat[]{FileFormats.TEXT};
    private Heatmap hm;
    private ExportHeatmapLabelsPage sourcePage;
    private PatternSourcePage patPage;
    private SaveFilePage savePage;

    public ExportHeatmapLabelsWizard(Heatmap hm) {
        this.hm = hm;
        this.setTitle("Export labels ...");
    }

    public void addPages() {
        this.sourcePage = new ExportHeatmapLabelsPage();
        this.addPage((IWizardPage)this.sourcePage);
        this.patPage = new PatternSourcePage(true);
        this.addPage((IWizardPage)this.patPage);
        this.savePage = new SaveFilePage();
        this.savePage.setTitle("Select destination file");
        this.savePage.setFolder(Settings.getDefault().getLastExportPath());
        this.savePage.setFormats(this.supportedFormats);
        this.addPage((IWizardPage)this.savePage);
    }

    public void performFinish() {
        Settings.getDefault().setLastExportPath(this.savePage.getFolder());
        Settings.getDefault().save();
    }

    public void pageLeft(IWizardPage page) {
        if (page == this.sourcePage) {
            switch (this.sourcePage.getWhichLabels()) {
                case VISIBLE_ROWS: 
                case HIDDEN_ROWS: {
                    this.patPage.setAnnotationMatrix(this.hm.getRowDim().getAnnotations());
                    break;
                }
                case VISIBLE_COLUMNS: 
                case HIDDEN_COLUMNS: {
                    this.patPage.setAnnotationMatrix(this.hm.getColumnDim().getAnnotations());
                }
            }
        }
    }

    public ExportHeatmapLabelsPage.WhichLabels getWhichLabels() {
        return this.sourcePage.getWhichLabels();
    }

    public String getPattern() {
        return this.patPage.getPattern();
    }

    public SaveFilePage getSavePage() {
        return this.savePage;
    }
}

