/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.welcome;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gitools.ui.actions.file.ImportBiomartModulesAction;
import org.gitools.ui.actions.file.ImportBiomartTableAction;
import org.gitools.ui.actions.file.ImportGoModulesAction;
import org.gitools.ui.actions.file.ImportIntogenMatrixAction;
import org.gitools.ui.actions.file.ImportIntogenOncomodulesAction;
import org.gitools.ui.actions.file.ImportKeggModulesAction;
import org.gitools.ui.actions.file.NewCombinationAnalysisAction;
import org.gitools.ui.actions.file.NewCorrelationAnalysisAction;
import org.gitools.ui.actions.file.NewEnrichmentAnalysisAction;
import org.gitools.ui.actions.file.NewOncodriveAnalysisAction;
import org.gitools.ui.actions.file.NewOverlappingAnalysisAction;
import org.gitools.ui.actions.file.OpenAnalysisAction;
import org.gitools.ui.actions.file.OpenHeatmapAction;
import org.gitools.ui.dialog.UnimplementedDialog;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.editor.Html4Editor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.welcome.BiomartTypeDialog;
import org.gitools.ui.welcome.DataHelpDialog;
import org.gitools.ui.welcome.DownloadExamplesDialog;
import org.gitools.ui.welcome.IntogenTypeDialog;
import org.slf4j.LoggerFactory;

public class WelcomeEditor
extends Html4Editor {
    private static final long serialVersionUID = 6851947500231401412L;

    public WelcomeEditor() {
        super("Welcome");
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/html/welcome.html");
            this.navigate(url);
        }
        catch (Exception e) {
            ExceptionDialog.show((Window)AppFrame.instance(), (Throwable)e);
        }
    }

    protected void performUrlAction(String name, Map<String, String> params) {
        if (name.equals("goHome")) {
            try {
                Desktop.getDesktop().browse(new URI("http://www.gitools.org"));
            }
            catch (Exception ex) {
                ExceptionDialog.show((Window)AppFrame.instance(), (Throwable)ex);
            }
        } else if (name.equals("importIntogen")) {
            IntogenTypeDialog dlg = new IntogenTypeDialog(AppFrame.instance());
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                switch (dlg.getSelection()) {
                    case 1: {
                        new ImportIntogenMatrixAction().actionPerformed(new ActionEvent((Object)this, 0, name));
                        break;
                    }
                    case 2: {
                        new ImportIntogenOncomodulesAction().actionPerformed(new ActionEvent((Object)this, 0, name));
                    }
                }
            }
        } else if (name.equals("importGo")) {
            new ImportGoModulesAction().actionPerformed(new ActionEvent((Object)this, 0, name));
        } else if (name.equals("importKegg")) {
            new ImportKeggModulesAction().actionPerformed(new ActionEvent((Object)this, 0, name));
        } else if (name.equals("importBiomart")) {
            BiomartTypeDialog dlg = new BiomartTypeDialog(AppFrame.instance());
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                switch (dlg.getSelection()) {
                    case 1: {
                        new ImportBiomartTableAction().actionPerformed(new ActionEvent((Object)this, 0, name));
                        break;
                    }
                    case 2: {
                        new ImportBiomartModulesAction().actionPerformed(new ActionEvent((Object)this, 0, name));
                    }
                }
            }
        } else if (name.equals("analysis")) {
            HashMap<String, Class<NewCombinationAnalysisAction>> actions = new HashMap<String, Class<NewCombinationAnalysisAction>>();
            actions.put("Enrichment", NewEnrichmentAnalysisAction.class);
            actions.put("Oncodrive", NewOncodriveAnalysisAction.class);
            actions.put("Correlations", NewCorrelationAnalysisAction.class);
            actions.put("Overlapping", NewOverlappingAnalysisAction.class);
            actions.put("Combination", NewCombinationAnalysisAction.class);
            String ref = params.get("ref");
            Class actionClass = (Class)actions.get(ref);
            if (actionClass != null) {
                try {
                    ActionEvent event = new ActionEvent((Object)this, 0, name);
                    ((BaseAction)actionClass.newInstance()).actionPerformed(event);
                }
                catch (Exception ex) {
                    ExceptionDialog.show((Window)AppFrame.instance(), (Throwable)ex);
                }
            } else {
                UnimplementedDialog.show(AppFrame.instance());
            }
        } else if (name.equals("open")) {
            String ref = params.get("ref");
            if (ref.equals("Analysis")) {
                new OpenAnalysisAction().actionPerformed(new ActionEvent((Object)this, 0, name));
            } else if (ref.equals("DataHeatmap")) {
                new OpenHeatmapAction().actionPerformed(new ActionEvent((Object)this, 0, name));
            }
        } else if (name.equals("example")) {
            LoggerFactory.getLogger(WelcomeEditor.class).debug("example: " + params);
        } else if (name.equals("downloadExamples")) {
            DownloadExamplesDialog dlg = new DownloadExamplesDialog(AppFrame.instance());
            dlg.setPath(Settings.getDefault().getLastWorkPath());
            dlg.setVisible(true);
            this.downloadExamples(dlg.getPath());
        } else if (name.equals("dataMatrices") || name.equals("dataModules") || name.equals("dataTables")) {
            DataHelpDialog dlg = new DataHelpDialog(AppFrame.instance());
            dlg.setVisible(true);
        }
    }

    public void doVisible() {
        AppFrame.instance().setLeftPanelVisible(false);
    }

    private void downloadExamples(final String path) {
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    ZipEntry ze;
                    monitor.begin("Connecting ...", 1);
                    URL url = new URL("http://webstart.gitools.org/examples.zip");
                    ZipInputStream zin = new ZipInputStream(url.openStream());
                    File pathFile = new File(path);
                    monitor.end();
                    monitor.begin("Downloading ...", 1);
                    while ((ze = zin.getNextEntry()) != null) {
                        int count;
                        IProgressMonitor mnt = monitor.subtask();
                        long totalKb = ze.getSize() / 1024L;
                        String name = ze.getName();
                        mnt.begin("Extracting " + name + " ...", (int)ze.getSize());
                        File outFile = new File(pathFile, name);
                        if (!outFile.getParentFile().exists()) {
                            outFile.getParentFile().mkdirs();
                        }
                        FileOutputStream fout = new FileOutputStream(outFile);
                        int BUFFER_SIZE = 4096;
                        byte[] data = new byte[4096];
                        int partial = 0;
                        while ((count = zin.read(data, 0, 4096)) != -1) {
                            ((OutputStream)fout).write(data, 0, count);
                            mnt.info((partial += count) / 1024 + " Kb read");
                            mnt.worked(count);
                        }
                        zin.closeEntry();
                        ((OutputStream)fout).close();
                        mnt.end();
                    }
                    zin.close();
                    monitor.end();
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

