/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.utils;

import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.settings.Settings;

public class FileChooserUtils {
    public static final int MODE_SAVE = 1;
    public static final int MODE_OPEN = 2;
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";
    public static final String pdf = "pdf";
    private static FileFilter imageFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileChooserUtils.getExtension(f);
            if (extension != null) {
                return FileChooserUtils.isImageExtension(extension);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Image files (*.png, *.jpg, *.jpeg, *.gif)";
        }
    };
    private static FileFilter pdfFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileChooserUtils.getExtension(f);
            if (extension != null) {
                return extension.equals(FileChooserUtils.pdf);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Image files (*.pdf)";
        }
    };

    public static File selectFile(String title, int mode) {
        return FileChooserUtils.selectFile(title, Settings.getDefault().getLastPath(), mode);
    }

    public static File selectFile(String title, String currentPath, int mode) {
        JFileChooser fileChooser = new JFileChooser(currentPath);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setPreferredSize(new Dimension(640, 480));
        int retval = 1;
        if (mode == 1) {
            retval = fileChooser.showSaveDialog(AppFrame.instance());
        } else if (mode == 2) {
            retval = fileChooser.showOpenDialog(AppFrame.instance());
        }
        if (retval == 0) {
            File file = fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    public static FileAndFilter selectFile(String title, int mode, FileFilter[] filters) {
        return FileChooserUtils.selectFile(title, Settings.getDefault().getLastPath(), mode, filters);
    }

    public static FileAndFilter selectFile(String title, String currentPath, int mode, FileFilter[] filters) {
        JFileChooser fileChooser = new JFileChooser(currentPath);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setPreferredSize(new Dimension(640, 480));
        if (filters != null) {
            fileChooser.setAcceptAllFileFilterUsed(false);
            for (FileFilter filter : filters) {
                fileChooser.addChoosableFileFilter(filter);
            }
            if (filters.length > 0) {
                fileChooser.setFileFilter(filters[0]);
            }
        }
        int retval = 1;
        if (mode == 1) {
            retval = fileChooser.showSaveDialog(AppFrame.instance());
        } else if (mode == 2) {
            retval = fileChooser.showOpenDialog(AppFrame.instance());
        }
        if (retval == 0) {
            return new FileAndFilter(fileChooser.getSelectedFile(), fileChooser.getFileFilter());
        }
        return null;
    }

    public static File selectPath(String title) {
        return FileChooserUtils.selectPath(title, Settings.getDefault().getLastPath());
    }

    public static File selectPath(String title, String currentPath) {
        JFileChooser fileChooser = new JFileChooser(currentPath);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setPreferredSize(new Dimension(640, 480));
        int retval = fileChooser.showOpenDialog(AppFrame.instance());
        if (retval == 0) {
            File file = fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    public static File selectImageFile(String title, String currentPath, int mode) {
        JFileChooser fileChooser = new JFileChooser(currentPath);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(imageFileFilter);
        fileChooser.setPreferredSize(new Dimension(640, 480));
        int retval = 1;
        if (mode == 1) {
            retval = fileChooser.showSaveDialog(AppFrame.instance());
        } else if (mode == 2) {
            retval = fileChooser.showOpenDialog(AppFrame.instance());
        }
        if (retval == 0) {
            File file = fileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    public static String getExtension(File file) {
        return FileChooserUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isImageExtension(String extension) {
        return extension.equals(tif) || extension.equals(gif) || extension.equals(jpeg) || extension.equals(jpg) || extension.equals(png);
    }

    public static class FileAndFilter {
        private File file;
        private FileFilter filter;

        public FileAndFilter(File file, FileFilter filter) {
            this.file = file;
            this.filter = filter;
        }

        public File getFile() {
            return this.file;
        }

        public FileFilter getFilter() {
            return this.filter;
        }
    }
}

