/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.sort;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.gitools.aggregation.IAggregator;
import org.gitools.matrix.sort.ValueSortCriteria;
import org.gitools.ui.sort.ValueSortCriteriaTableModel;

public class ValueSortDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private String[] attributeNames;
    private IAggregator[] aggregators;
    private ValueSortCriteria.SortDirection[] directions;
    private ValueSortCriteriaTableModel criteriaModel;
    private JRadioButton applyToColumnsRb;
    private ButtonGroup applyToGroup;
    private JRadioButton applyToRowsAndColumnsRb;
    private JRadioButton applyToRowsRb;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton loadBtn;
    private JButton okButton;
    private JButton saveBtn;
    private JTable table;
    private JButton tableAddBtn;
    private JButton tableRemoveBtn;
    private int returnStatus = 0;

    public ValueSortDialog(Frame parent, String[] attributeNames, IAggregator[] aggregators, ValueSortCriteria.SortDirection[] directions, List<ValueSortCriteria> initialCriteriaList) {
        super(parent, true);
        this.attributeNames = attributeNames;
        this.aggregators = aggregators;
        this.directions = directions;
        this.criteriaModel = new ValueSortCriteriaTableModel(attributeNames);
        this.initComponents();
        this.table.setModel(this.criteriaModel);
        this.criteriaModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ValueSortDialog.this.tableRemoveBtn.setEnabled(ValueSortDialog.this.criteriaModel.getList().size() > 0);
            }
        });
        if (initialCriteriaList != null) {
            this.criteriaModel.addAllCriteria(initialCriteriaList);
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new ComboBoxCellEditor(attributeNames));
        columnModel.getColumn(1).setCellEditor(new ComboBoxCellEditor(aggregators));
        columnModel.getColumn(2).setCellEditor(new ComboBoxCellEditor(directions));
    }

    public boolean isCancelled() {
        return this.returnStatus != 1;
    }

    private void initComponents() {
        this.applyToGroup = new ButtonGroup();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.tableAddBtn = new JButton();
        this.tableRemoveBtn = new JButton();
        this.loadBtn = new JButton();
        this.saveBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.applyToRowsRb = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.applyToRowsAndColumnsRb = new JRadioButton();
        this.applyToColumnsRb = new JRadioButton();
        this.setTitle("Sort by value");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ValueSortDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValueSortDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValueSortDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Attribute", "Condition", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Object.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.table);
        this.table.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.tableAddBtn.setText("Add");
        this.tableAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValueSortDialog.this.tableAddBtnActionPerformed(evt);
            }
        });
        this.tableRemoveBtn.setText("Remove");
        this.tableRemoveBtn.setEnabled(false);
        this.tableRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValueSortDialog.this.tableRemoveBtnActionPerformed(evt);
            }
        });
        this.loadBtn.setText("Load...");
        this.loadBtn.setEnabled(false);
        this.saveBtn.setText("Save...");
        this.saveBtn.setEnabled(false);
        this.applyToGroup.add(this.applyToRowsRb);
        this.applyToRowsRb.setSelected(true);
        this.applyToRowsRb.setText("rows");
        this.jLabel2.setText("Apply to:");
        this.applyToGroup.add(this.applyToRowsAndColumnsRb);
        this.applyToRowsAndColumnsRb.setText("rows and columns");
        this.applyToGroup.add(this.applyToColumnsRb);
        this.applyToColumnsRb.setText("columns");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 557, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 481, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.saveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.loadBtn, -1, -1, Short.MAX_VALUE).addComponent(this.tableAddBtn, -1, -1, Short.MAX_VALUE).addComponent(this.tableRemoveBtn, -1, -1, Short.MAX_VALUE))).addComponent(this.applyToRowsRb).addComponent(this.applyToColumnsRb).addComponent(this.applyToRowsAndColumnsRb).addComponent(this.jLabel2)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tableAddBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn)).addComponent(this.jScrollPane1, -1, 183, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyToRowsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToColumnsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToRowsAndColumnsRb).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void tableAddBtnActionPerformed(ActionEvent evt) {
        this.criteriaModel.addCriteria(new ValueSortCriteria(this.attributeNames[0], 0, this.aggregators[0], this.directions[0]));
    }

    private void tableRemoveBtnActionPerformed(ActionEvent evt) {
        this.criteriaModel.removeCriteria(this.table.getSelectedRows());
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isApplyToRowsChecked() {
        return this.applyToRowsRb.isSelected() || this.applyToRowsAndColumnsRb.isSelected();
    }

    public boolean isApplyToColumnsChecked() {
        return this.applyToColumnsRb.isSelected() || this.applyToRowsAndColumnsRb.isSelected();
    }

    public List<ValueSortCriteria> getCriteriaList() {
        return this.criteriaModel.getList();
    }

    private static class ComboBoxCellEditor
    extends DefaultCellEditor {
        public ComboBoxCellEditor(Object[] values) {
            super(new JComboBox<Object>(values));
        }
    }

    private static class ComboBoxCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxCellRenderer(Object[] values) {
            super(values);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

