/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.sort;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.gitools.aggregation.IAggregator;
import org.gitools.matrix.sort.ValueSortCriteria;

class ValueSortCriteriaTableModel
implements TableModel {
    private static final String[] columnName = new String[]{"Attribute", "Agregation", "Direction"};
    private static final Class<?>[] columnClass = new Class[]{String.class, CutoffCmp.class, ValueSortCriteria.SortDirection.class};
    private Map<String, Integer> attrIndexMap = new HashMap<String, Integer>();
    private List<ValueSortCriteria> criteriaList;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public ValueSortCriteriaTableModel(List<ValueSortCriteria> criteriaList, String[] attributeNames) {
        this.criteriaList = criteriaList;
        for (int i = 0; i < attributeNames.length; ++i) {
            this.attrIndexMap.put(attributeNames[i], i);
        }
    }

    public ValueSortCriteriaTableModel(String[] attributeNames) {
        this(new ArrayList<ValueSortCriteria>(), attributeNames);
    }

    @Override
    public int getRowCount() {
        return this.criteriaList.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnName[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnClass[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.criteriaList.get(rowIndex).getAttributeName();
            }
            case 1: {
                return this.criteriaList.get(rowIndex).getAggregator();
            }
            case 2: {
                return this.criteriaList.get(rowIndex).getDirection();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String attrName = (String)aValue;
                this.criteriaList.get(rowIndex).setAttributeName(attrName);
                Integer index = this.attrIndexMap.get(attrName);
                this.criteriaList.get(rowIndex).setAttributeIndex(index != null ? index : 0);
                break;
            }
            case 1: {
                this.criteriaList.get(rowIndex).setAggregator((IAggregator)aValue);
                break;
            }
            case 2: {
                this.criteriaList.get(rowIndex).setDirection((ValueSortCriteria.SortDirection)aValue);
            }
        }
    }

    public List<ValueSortCriteria> getList() {
        return this.criteriaList;
    }

    public void addCriteria(ValueSortCriteria criteria) {
        this.criteriaList.add(criteria);
        this.fireCriteriaChanged();
    }

    void addAllCriteria(List<ValueSortCriteria> list) {
        this.criteriaList.addAll(list);
        this.fireCriteriaChanged();
    }

    void removeCriteria(int[] selectedRows) {
        ArrayList<ValueSortCriteria> objects = new ArrayList<ValueSortCriteria>(selectedRows.length);
        for (int index : selectedRows) {
            objects.add(this.criteriaList.get(index));
        }
        this.criteriaList.removeAll(objects);
        this.fireCriteriaChanged();
    }

    private void fireCriteriaChanged() {
        TableModelEvent e = new TableModelEvent(this);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

