/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.sort;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.sort.ValueSortCriteria;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.PageDialog;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.wizard.common.PatternSourcePage;

public class LabelSortPage
extends AbstractWizardPage {
    private Heatmap hm;
    private String rowsPat;
    private String colsPat;
    private JCheckBox colsChk;
    private JComboBox colsDirCb;
    private JButton colsLabelBtn;
    private JTextField colsLabelFld;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JCheckBox rowsChk;
    private JComboBox rowsDirCb;
    private JButton rowsLabelBtn;
    private JTextField rowsLabelFld;

    public LabelSortPage(Heatmap hm) {
        this.hm = hm;
        this.initComponents();
        this.rowsLabelFld.setText("id");
        this.rowsPat = "${id}";
        this.colsLabelFld.setText("id");
        this.colsPat = "${id}";
        ActionListener dimListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelSortPage.this.dimChanged();
            }
        };
        this.rowsChk.addActionListener(dimListener);
        this.colsChk.addActionListener(dimListener);
        this.rowsLabelFld.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                LabelSortPage.this.updateComplete();
            }
        });
        this.rowsLabelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelSortPage.this.selectRowsPattern();
            }
        });
        this.rowsDirCb.setModel(new DefaultComboBoxModel<ValueSortCriteria.SortDirection>(ValueSortCriteria.SortDirection.values()));
        this.colsLabelFld.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                LabelSortPage.this.updateComplete();
            }
        });
        this.colsLabelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelSortPage.this.selectColsPattern();
            }
        });
        this.colsDirCb.setModel(new DefaultComboBoxModel<ValueSortCriteria.SortDirection>(ValueSortCriteria.SortDirection.values()));
        this.setTitle("Sort by label");
        this.updateComplete();
    }

    public void updateControls() {
        this.dimChanged();
    }

    private void updateComplete() {
        this.setComplete(!(!this.rowsChk.isSelected() && !this.colsChk.isSelected() || this.rowsChk.isSelected() && this.rowsLabelFld.getText().isEmpty() || this.colsChk.isSelected() && this.colsLabelFld.getText().isEmpty()));
    }

    private void dimChanged() {
        boolean rs = this.rowsChk.isSelected();
        this.rowsLabelFld.setEnabled(rs);
        this.rowsLabelBtn.setEnabled(rs);
        this.rowsDirCb.setEnabled(rs);
        boolean cs = this.colsChk.isSelected();
        this.colsLabelFld.setEnabled(cs);
        this.colsLabelBtn.setEnabled(cs);
        this.colsDirCb.setEnabled(cs);
        this.updateComplete();
    }

    private void selectRowsPattern() {
        PatternSourcePage page = new PatternSourcePage(this.hm.getRowDim().getAnnotations(), true);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.rowsPat = page.getPattern();
        this.rowsLabelFld.setText(page.getPatternTitle());
    }

    private void selectColsPattern() {
        PatternSourcePage page = new PatternSourcePage(this.hm.getColumnDim().getAnnotations(), true);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.colsPat = page.getPattern();
        this.colsLabelFld.setText(page.getPatternTitle());
    }

    public boolean isApplyToRowsSelected() {
        return this.rowsChk.isSelected();
    }

    public String getRowsPattern() {
        return this.rowsPat;
    }

    public ValueSortCriteria.SortDirection getRowsDirection() {
        return (ValueSortCriteria.SortDirection)this.rowsDirCb.getSelectedItem();
    }

    public boolean isApplyToColumnsSelected() {
        return this.colsChk.isSelected();
    }

    public String getColumnsPattern() {
        return this.colsPat;
    }

    public ValueSortCriteria.SortDirection getColumnsDirection() {
        return (ValueSortCriteria.SortDirection)this.colsDirCb.getSelectedItem();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.rowsDirCb = new JComboBox();
        this.rowsChk = new JCheckBox();
        this.rowsLabelFld = new JTextField();
        this.rowsLabelBtn = new JButton();
        this.jLabel2 = new JLabel();
        this.colsChk = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.colsLabelFld = new JTextField();
        this.colsLabelBtn = new JButton();
        this.jLabel4 = new JLabel();
        this.colsDirCb = new JComboBox();
        this.jLabel1.setText("Direction");
        this.rowsChk.setSelected(true);
        this.rowsChk.setText("Rows");
        this.rowsLabelFld.setEditable(false);
        this.rowsLabelBtn.setText("Change...");
        this.jLabel2.setText("Label");
        this.colsChk.setText("Columns");
        this.jLabel3.setText("Label");
        this.colsLabelFld.setEditable(false);
        this.colsLabelBtn.setText("Change...");
        this.jLabel4.setText("Direction");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rowsChk).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsDirCb, 0, 204, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsLabelFld, -1, 230, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsLabelBtn)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colsChk).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsDirCb, 0, 204, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsLabelFld, -1, 230, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsLabelBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rowsChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.rowsLabelFld, -2, -1, -2).addComponent(this.rowsLabelBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.rowsDirCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.colsChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.colsLabelFld, -2, -1, -2).addComponent(this.colsLabelBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.colsDirCb, -2, -1, -2)).addContainerGap(58, Short.MAX_VALUE)));
    }
}

