/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.settings.decorators;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.utils.DocumentChangeListener;

public class SaveDecoratorDialog
extends JDialog {
    private Set<String> existingScaleNames;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static final String MESSAGE = "Enter a name for your scale";
    private JButton cancelButton;
    private DialogHeaderPanel headerPanel;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JTextField name;
    private JButton okButton;
    private int returnStatus = 0;

    public SaveDecoratorDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.headerPanel.setTitle("Save Scale");
        this.headerPanel.setMessage(MESSAGE);
        this.okButton.setEnabled(false);
        DocumentChangeListener documentListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                boolean exists = SaveDecoratorDialog.this.checkScaleNameExists();
                if (exists) {
                    SaveDecoratorDialog.this.headerPanel.setMessageStatus(MessageStatus.WARN);
                    SaveDecoratorDialog.this.headerPanel.setMessage("Scale name already exists and will be overwriten");
                } else {
                    SaveDecoratorDialog.this.headerPanel.setMessageStatus(MessageStatus.INFO);
                    SaveDecoratorDialog.this.headerPanel.setMessage(SaveDecoratorDialog.MESSAGE);
                }
                if (SaveDecoratorDialog.this.name.getText().isEmpty()) {
                    SaveDecoratorDialog.this.okButton.setEnabled(false);
                } else {
                    SaveDecoratorDialog.this.okButton.setEnabled(true);
                }
            }
        };
        this.name.getDocument().addDocumentListener(documentListener);
    }

    public DialogHeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public void setExistingScaleNames(Set<String> existingScaleNames) {
        this.existingScaleNames = existingScaleNames;
    }

    public boolean checkScaleNameExists() {
        return this.existingScaleNames.contains(this.name.getText());
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public boolean isCancelled() {
        return this.returnStatus == 0;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.name = new JTextField();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.headerPanel = new DialogHeaderPanel();
        this.setTitle("Save Scale");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SaveDecoratorDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveDecoratorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveDecoratorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name");
        this.headerPanel.setMessage("");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.headerPanel, -1, 731, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -1, 710, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(0, 570, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.name, -1, 658, Short.MAX_VALUE))).addGap(9, 9, 9)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.headerPanel, -1, 64, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.name, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addGap(29, 29, 29)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public String getScaleName() {
        return this.name.getText();
    }
}

