/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.settings.decorators;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.utils.DocumentChangeListener;

public class LoadDecoratorDialog<T>
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static final String MESSAGE = "Select a scale";
    private static IElementAdapter adapter;
    private List<T> listObjects = new ArrayList<T>();
    private DefaultListModel model;
    private JButton cancelButton;
    private JTextField filter;
    private DialogHeaderPanel headerPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JList list;
    private JButton okButton;
    private int returnStatus = 0;

    public LoadDecoratorDialog(Window parent, IElementAdapter adapter, T[] objects) {
        this(parent, adapter, objects, null);
    }

    public LoadDecoratorDialog(Window parent, IElementAdapter adapter, T[] objects, Class<? extends ElementDecorator> decoratorClass) {
        super(parent);
        LoadDecoratorDialog.adapter = adapter;
        this.setModal(true);
        this.initComponents();
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LoadDecoratorDialog.this.okButton.setEnabled(!LoadDecoratorDialog.this.list.getSelectionModel().isSelectionEmpty());
            }
        });
        this.model = new DefaultListModel();
        this.list.setCellRenderer(new DecoratorListCellRenderer());
        this.list.setModel(this.model);
        if (decoratorClass != null) {
            for (T o : objects) {
                if (!o.getClass().equals(decoratorClass)) continue;
                this.listObjects.add(o);
            }
        } else {
            this.listObjects.addAll(Arrays.asList(objects));
        }
        Collections.sort(this.listObjects, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                ElementDecorator d1 = (ElementDecorator)o1;
                ElementDecorator d2 = (ElementDecorator)o2;
                return d1.getName().compareToIgnoreCase(d2.getName());
            }
        });
        this.resetList("");
        this.okButton.setEnabled(false);
        this.headerPanel.setTitle("Load Scale");
        this.headerPanel.setMessage(MESSAGE);
        this.okButton.setEnabled(false);
        DocumentChangeListener documentListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                int elementCount = LoadDecoratorDialog.this.resetList(LoadDecoratorDialog.this.filter.getText());
                if (elementCount == 0) {
                    LoadDecoratorDialog.this.headerPanel.setMessageStatus(MessageStatus.WARN);
                    LoadDecoratorDialog.this.headerPanel.setMessage("No scale matches your filter");
                } else {
                    LoadDecoratorDialog.this.headerPanel.setMessageStatus(MessageStatus.INFO);
                    LoadDecoratorDialog.this.headerPanel.setMessage(LoadDecoratorDialog.MESSAGE);
                }
            }
        };
        this.filter.getDocument().addDocumentListener(documentListener);
    }

    public DialogHeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public ElementDecorator getSelectedDecorator() {
        ElementDecorator d = (ElementDecorator)this.list.getSelectedValue();
        d.setAdapter(adapter);
        return d;
    }

    private int resetList(String filter) {
        this.model.clear();
        for (T o : this.listObjects) {
            if (filter.isEmpty()) {
                this.model.addElement(o);
                continue;
            }
            ElementDecorator d = (ElementDecorator)o;
            String regexFilter = "(?i).*" + filter + ".*";
            boolean b = d.getName().matches(regexFilter);
            if (!b) continue;
            this.model.addElement(o);
        }
        return this.model.getSize();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public boolean isCancelled() {
        return this.returnStatus == 0;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filter = new JTextField();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.headerPanel = new DialogHeaderPanel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.setTitle("Load Scale");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoadDecoratorDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadDecoratorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadDecoratorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Filter");
        this.headerPanel.setMessage("");
        this.list.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.list);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.headerPanel, -1, 742, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filter).addComponent(this.jScrollPane1)).addGap(82, 82, 82)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()))));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.headerPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.filter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 181, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addGap(5, 5, 5)));
        this.getAccessibleContext().setAccessibleName("Load Decorator");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private String getFilter() {
        return this.filter.getText();
    }

    private static class DecoratorListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
            ElementDecorator d = (ElementDecorator)o;
            Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)jlist, d.getName(), i, bln, bln1);
            return listCellRendererComponent;
        }
    }
}

