/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.settings.decorators;

import com.thoughtworks.xstream.XStream;
import edu.upf.bg.colorscale.impl.CorrelationColorScale;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.impl.BinaryElementDecorator;
import org.gitools.model.decorator.impl.CorrelationElementDecorator;
import org.gitools.model.decorator.impl.FormattedTextElementDecorator;
import org.gitools.model.decorator.impl.LinearTwoSidedElementDecorator;
import org.gitools.model.decorator.impl.PValueElementDecorator;
import org.gitools.model.decorator.impl.ZScoreElementDecorator;
import org.gitools.ui.settings.decorators.DecoratorArchive;

public class DecoratorArchivePersistance {
    private static transient XStream xstream;
    private static final String userPath;
    public static final String CONFIG_PATH;
    private static final String configFileName = "scales.xml";
    private static final String configFile;

    public DecoratorArchivePersistance() {
        xstream = new XStream();
        xstream.alias("decoratorArchive", DecoratorArchive.class);
        xstream.alias("correlationColorScale", CorrelationColorScale.class);
        xstream.alias("binaryDecorator", BinaryElementDecorator.class);
        xstream.omitField(BinaryElementDecorator.class, "valueIndex");
        xstream.alias("linearTwoSidedDecorator", LinearTwoSidedElementDecorator.class);
        xstream.omitField(LinearTwoSidedElementDecorator.class, "valueIndex");
        xstream.alias("formattedTextDecorator", FormattedTextElementDecorator.class);
        xstream.omitField(FormattedTextElementDecorator.class, "valueIndex");
        xstream.alias("pValueDecorator", PValueElementDecorator.class);
        xstream.omitField(PValueElementDecorator.class, "valueIndex");
        xstream.omitField(PValueElementDecorator.class, "correctedValueIndex");
        xstream.alias("zScoreDecorator", ZScoreElementDecorator.class);
        xstream.omitField(ZScoreElementDecorator.class, "valueIndex");
        xstream.omitField(ZScoreElementDecorator.class, "correctedValueIndex");
        xstream.alias("correlationDecorator", CorrelationElementDecorator.class);
        xstream.omitField(CorrelationElementDecorator.class, "valueIndex");
        xstream.omitField(ElementDecorator.class, "valueIndex");
        xstream.omitField(ElementDecorator.class, "adapter");
        xstream.useAttributeFor(ElementDecorator.class, "name");
        xstream.omitField(Color.class, "alpha");
        xstream.setMode(1001);
    }

    public void save(DecoratorArchive archive) {
        File path = new File(CONFIG_PATH);
        if (!path.exists()) {
            path.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            writer.write("<!-- scales.xml version 2.0 -->\n");
            xstream.toXML((Object)archive, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DecoratorArchive load() {
        DecoratorArchive decoratorArchive;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            String firstLine = reader.readLine();
            if (!firstLine.matches("(.*)" + Pattern.quote("version 2.0") + "(.*)")) {
                System.err.println("Current scales.xml file not compatible with current version.");
                reader.close();
                FileUtils.copyFile((File)new File(configFile), (File)new File(configFile + ".backup"));
                decoratorArchive = new DecoratorArchive();
                decoratorArchive.add(decoratorArchive.getDefaultElementDecoratros());
                this.save(decoratorArchive);
                System.err.println("Created scales file with defaults and there is a backup copy on scales.xml.backup");
            } else {
                decoratorArchive = (DecoratorArchive)xstream.fromXML((Reader)reader, (Object)new DecoratorArchive());
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Settings file doesn't exist: " + configFile);
            System.err.println("Created scales file with defaults.");
            decoratorArchive = new DecoratorArchive();
            decoratorArchive.add(decoratorArchive.getDefaultElementDecoratros());
            this.save(decoratorArchive);
        }
        catch (Exception e) {
            decoratorArchive = new DecoratorArchive();
            e.printStackTrace();
        }
        return decoratorArchive;
    }

    static {
        userPath = System.getProperty("user.home", ".");
        CONFIG_PATH = userPath + File.separator + ".gitools";
        configFile = CONFIG_PATH + File.separator + configFileName;
    }
}

