/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.settings.decorators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorDescriptor;
import org.gitools.model.decorator.ElementDecoratorFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DecoratorArchive {
    public static final transient String VERSION = "2.0";
    private List<ElementDecorator> scaleDecorators = new ArrayList<ElementDecorator>();
    private final transient String DEFAULT = "Default";

    public void add(ElementDecorator[] decorators) {
        for (ElementDecorator d : decorators) {
            this.add(d);
        }
    }

    public void add(ElementDecorator decorator) {
        String name = decorator.getName();
        Set<String> map = this.getDecorators().keySet();
        if (map.contains(name)) {
            this.remove(this.scaleDecorators, name);
            this.scaleDecorators.add(decorator);
        } else {
            this.scaleDecorators.add(decorator);
        }
    }

    private void remove(List<ElementDecorator> scaleDecorators, String name) {
        for (ElementDecorator d : scaleDecorators) {
            if (!d.getName().equals(name)) continue;
            scaleDecorators.remove(d);
            return;
        }
    }

    public Map<String, ElementDecorator> getDecorators() {
        HashMap<String, ElementDecorator> decoratorMap = new HashMap<String, ElementDecorator>();
        for (ElementDecorator d : this.scaleDecorators) {
            decoratorMap.put(d.getName(), d);
        }
        return decoratorMap;
    }

    public ElementDecorator[] getDefaultElementDecoratros() {
        List descriptors = ElementDecoratorFactory.getDescriptors();
        ElementDecorator[] decorators = new ElementDecorator[descriptors.size()];
        int i = 0;
        for (ElementDecoratorDescriptor descriptor : descriptors) {
            ElementDecorator decorator = null;
            try {
                decorator = (ElementDecorator)descriptor.getDecoratorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
            decorator.setName("Default " + descriptor.getName());
            decorators[i] = decorator;
            ++i;
        }
        return decorators;
    }
}

