/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Settings {
    public static final String DEFAULT_INTOGEN_URL = "http://www.intogen.org";
    public static final String DEFAULT_INTOGEN_ONCOMODULES_URL = "http://www.intogen.org/oncomodules";
    public static final String DEFAULT_INTOGEN_DATA_URL = "http://www.intogen.org/oncodata";
    public static final String DEFAULT_IGV_URL = "http://127.0.0.1:60151";
    private static final String userPath = System.getProperty("user.home", ".");
    public static final String CONFIG_PATH = userPath + File.separator + ".gitools";
    private static final String configFileName = "ui.xml";
    private static final String configFile = CONFIG_PATH + File.separator + "ui.xml";
    private static final String defaultWorkspacePath = CONFIG_PATH + File.separator + "workspace";
    private static Settings instance;
    private String version;
    private String lastPath = userPath;
    private String lastImportPath = userPath;
    private String lastExportPath = userPath;
    private String lastWorkPath = userPath;
    private String lastDataPath = userPath;
    private String lastMapPath = userPath;
    private String lastAnnotationPath = userPath;
    private String lastFilterPath = userPath;
    private String workspacePath = defaultWorkspacePath;
    private String intogenOncomodulesUrl = "http://www.intogen.org/oncomodules";
    private String intogenDataUrl = "http://www.intogen.org/oncodata";
    private boolean showEnrichmentExamplePage = true;
    private boolean showOncodriveExamplePage = true;
    private boolean showCorrelationExamplePage = true;
    private boolean showOverlapExamplePage = true;
    private boolean showCombinationExamplePage = true;
    private boolean portEnabled = true;
    private int defaultPort = 50151;
    private boolean showIGVLink = true;
    private String igvUrl = "http://127.0.0.1:60151";
    private int igvTimeout = 3000;
    private boolean previewFeatures = false;

    public static Settings getDefault() {
        if (instance == null) {
            instance = Settings.load();
        }
        return instance;
    }

    private static Settings load() {
        Settings settings = null;
        try {
            FileReader reader = new FileReader(configFile);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Unmarshaller u = context.createUnmarshaller();
            settings = (Settings)u.unmarshal((Reader)reader);
            ((Reader)reader).close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Settings file doesn't exist: " + configFile);
            System.err.println("Created one with defaults.");
            settings = new Settings();
            settings.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            settings = new Settings();
        }
        return settings;
    }

    private Settings() {
    }

    public void save() {
        File path = new File(CONFIG_PATH);
        if (!path.exists()) {
            path.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)this, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public void setLastPath(String lastPath) {
        this.lastPath = lastPath;
    }

    public String getLastImportPath() {
        return this.lastImportPath;
    }

    public void setLastImportPath(String lastImportPath) {
        this.lastImportPath = lastImportPath;
    }

    public String getLastExportPath() {
        return this.lastExportPath;
    }

    public void setLastExportPath(String lastExportPath) {
        this.lastExportPath = lastExportPath;
    }

    public String getLastWorkPath() {
        return this.lastWorkPath;
    }

    public void setLastWorkPath(String lastWorkPath) {
        this.lastWorkPath = lastWorkPath;
    }

    public String getLastDataPath() {
        return this.lastDataPath;
    }

    public void setLastDataPath(String lastDataPath) {
        this.lastDataPath = lastDataPath;
    }

    public String getLastMapPath() {
        return this.lastMapPath;
    }

    public void setLastMapPath(String lastMapPath) {
        this.lastMapPath = lastMapPath;
    }

    public String getLastAnnotationPath() {
        return this.lastAnnotationPath;
    }

    public void setLastAnnotationPath(String lastAnnotationPath) {
        this.lastAnnotationPath = lastAnnotationPath;
    }

    public String getLastFilterPath() {
        return this.lastFilterPath;
    }

    public void setLastFilterPath(String lastFilterPath) {
        this.lastFilterPath = lastFilterPath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getIntogenOncomodulesUrl() {
        return this.intogenOncomodulesUrl;
    }

    public void setIntogenOncomodulesUrl(String intogenOncomodulesUrl) {
        this.intogenOncomodulesUrl = intogenOncomodulesUrl;
    }

    public String getIntogenDataUrl() {
        return this.intogenDataUrl;
    }

    public void setIntogenDataUrl(String intogenDataUrl) {
        this.intogenDataUrl = intogenDataUrl;
    }

    public boolean isShowEnrichmentExamplePage() {
        return this.showEnrichmentExamplePage;
    }

    public void setShowEnrichmentExamplePage(boolean showEnrichmentExamplePage) {
        this.showEnrichmentExamplePage = showEnrichmentExamplePage;
    }

    public boolean isShowOncodriveExamplePage() {
        return this.showOncodriveExamplePage;
    }

    public void setShowOncodriveExamplePage(boolean showOncodriveExamplePage) {
        this.showOncodriveExamplePage = showOncodriveExamplePage;
    }

    public boolean isShowCorrelationExamplePage() {
        return this.showCorrelationExamplePage;
    }

    public void setShowCorrelationExamplePage(boolean showCorrelationExamplePage) {
        this.showCorrelationExamplePage = showCorrelationExamplePage;
    }

    public boolean isShowCombinationExamplePage() {
        return this.showCombinationExamplePage;
    }

    public void setShowCombinationExamplePage(boolean showCombinationExamplePage) {
        this.showCombinationExamplePage = showCombinationExamplePage;
    }

    public boolean isShowOverlapExamplePage() {
        return this.showOverlapExamplePage;
    }

    public void setShowOverlapExamplePage(boolean showOverlapExamplePage) {
        this.showOverlapExamplePage = showOverlapExamplePage;
    }

    public boolean isPortEnabled() {
        return this.isPreviewFeatures() && this.portEnabled;
    }

    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getIgvUrl() {
        return this.igvUrl;
    }

    public void setIgvUrl(String igvUrl) {
        this.igvUrl = igvUrl;
    }

    public int getIgvTimeout() {
        return this.igvTimeout;
    }

    public void setIgvTimeout(int igvTimeout) {
        this.igvTimeout = igvTimeout;
    }

    public boolean isShowIGVLink() {
        return this.isPreviewFeatures() && this.showIGVLink;
    }

    public void setShowIGVLink(boolean showIGVLink) {
        this.showIGVLink = showIGVLink;
    }

    public boolean isPreviewFeatures() {
        return this.previewFeatures;
    }

    public void setPreviewFeatures(boolean previewFeatures) {
        this.previewFeatures = previewFeatures;
    }
}

