/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.scale;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class ScaleExportConfigPage
extends AbstractWizardPage {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox partialRangeCheck;
    private JTextField rangeMax;
    private JTextField rangeMin;
    private JTextField scaleSize;

    public ScaleExportConfigPage() {
        this.initComponents();
        this.setTitle("Scale export settings");
        DocumentChangeListener docListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                ScaleExportConfigPage.this.validateValues();
            }
        };
        this.partialRangeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScaleExportConfigPage.this.rangeMin.setEnabled(ScaleExportConfigPage.this.partialRangeCheck.isSelected());
                ScaleExportConfigPage.this.rangeMax.setEnabled(ScaleExportConfigPage.this.partialRangeCheck.isSelected());
            }
        });
        this.scaleSize.getDocument().addDocumentListener(docListener);
        this.rangeMin.getDocument().addDocumentListener(docListener);
        this.rangeMax.getDocument().addDocumentListener(docListener);
        this.setComplete(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.partialRangeCheck = new JCheckBox();
        this.rangeMin = new JTextField();
        this.jLabel2 = new JLabel();
        this.rangeMax = new JTextField();
        this.scaleSize = new JTextField();
        this.jLabel1.setText("Size (in pixels)");
        this.partialRangeCheck.setText("Export only values from");
        this.rangeMin.setColumns(5);
        this.rangeMin.setText("0");
        this.rangeMin.setEnabled(false);
        this.jLabel2.setText("to");
        this.rangeMax.setColumns(5);
        this.rangeMax.setText("0");
        this.rangeMax.setEnabled(false);
        this.scaleSize.setColumns(6);
        this.scaleSize.setText("1024");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleSize, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.partialRangeCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rangeMin, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rangeMax, -2, -1, -2))).addContainerGap(175, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.scaleSize, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.partialRangeCheck).addComponent(this.rangeMin, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.rangeMax, -2, -1, -2)).addContainerGap(340, Short.MAX_VALUE)));
    }

    public JComponent createControls() {
        return this;
    }

    protected void validateValues() {
        this.setComplete(true);
        this.setMessage(MessageStatus.INFO, "");
        try {
            Double.parseDouble(this.rangeMin.getText());
        }
        catch (NumberFormatException ex) {
            this.setComplete(false);
            this.setMessage(MessageStatus.ERROR, "Invalid range value: " + this.rangeMin.getText());
        }
        try {
            Double.parseDouble(this.rangeMax.getText());
        }
        catch (NumberFormatException ex) {
            this.setComplete(false);
            this.setMessage(MessageStatus.ERROR, "Invalid range value: " + this.rangeMax.getText());
        }
        try {
            Integer.parseInt(this.scaleSize.getText());
        }
        catch (NumberFormatException ex) {
            this.setComplete(false);
            this.setMessage(MessageStatus.ERROR, "Invalid size: " + this.scaleSize.getText());
        }
    }

    public void setRange(double min, double max) {
        this.rangeMin.setText(Double.toString(min));
        this.rangeMax.setText(Double.toString(max));
    }

    public boolean isPartialRange() {
        return this.partialRangeCheck.isSelected();
    }

    public double getRangeMin() {
        return Double.parseDouble(this.rangeMin.getText());
    }

    public double getRangeMax() {
        return Double.parseDouble(this.rangeMax.getText());
    }

    public int getScaleSize() {
        return Integer.parseInt(this.scaleSize.getText());
    }
}

