/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform;

import edu.upf.bg.progressmonitor.DefaultProgressMonitor;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -8072022883069269170L;
    private JLabel statusLabel;

    public StatusBar() {
        this.createComponents();
    }

    private void createComponents() {
        this.statusLabel = new JLabel();
        this.statusLabel.setHorizontalAlignment(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.statusLabel, "Center");
    }

    public void setText(final String text) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.statusLabel.setText(text);
                    StatusBar.this.statusLabel.repaint();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IProgressMonitor createMonitor() {
        return new StatusBarProgressMonitor();
    }

    private class StatusBarProgressMonitor
    extends DefaultProgressMonitor {
        public StatusBarProgressMonitor() {
        }

        public StatusBarProgressMonitor(IProgressMonitor parent) {
            super(parent);
        }

        @Override
        public void begin(String title, int totalWork) {
            super.begin(title, totalWork);
            StatusBar.this.setText(title);
        }

        @Override
        public void end() {
            super.end();
            StatusBar.this.setText("Ok");
        }

        @Override
        public IProgressMonitor subtask() {
            return new StatusBarProgressMonitor(this);
        }
    }
}

