/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.platform;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.gitools.ui.actions.Actions;
import org.gitools.ui.heatmap.editor.HeatmapDemoEditor;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.StatusBar;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.view.details.DetailsView;
import org.gitools.ui.view.properties.PropertiesView;
import org.gitools.ui.welcome.WelcomeEditor;
import org.gitools.ui.workspace.NavigatorPanel;
import org.gitools.workspace.Workspace;
import org.gitools.workspace.WorkspaceManager;

public class AppFrame
extends JFrame {
    private static final long serialVersionUID = -6899584212813749990L;
    private static String appName = "GiTools";
    private static String appVersion = AppFrame.class.getPackage().getImplementationVersion();
    private static final int defaultDividerLocation = 340;
    private WorkbenchLayout layout = WorkbenchLayout.LEFT;
    private JToolBar toolBar;
    private JTabbedPane leftPanel;
    private int leftPanelSize = 340;
    private NavigatorPanel navPanel;
    private DetailsView detailsView;
    private PropertiesView propertiesView;
    private EditorsPanel editorsPanel;
    private StatusBar statusBar;
    private JSplitPane splitPane;
    private static AppFrame instance;

    public static AppFrame instance() {
        if (instance == null) {
            instance = new AppFrame();
        }
        return instance;
    }

    private AppFrame() {
        this.createComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.getDefault().save();
                System.exit(0);
            }
        });
        this.setTitle(appName + " " + appVersion);
        this.setStatusText("Ok");
        this.setIconImage(IconUtils.getImageIconResource((String)"/img/LogoMini.png").getImage());
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(980, 680));
        this.pack();
    }

    public static String getAppName() {
        return appName;
    }

    public static String getAppVersion() {
        return appVersion;
    }

    private void createComponents() {
        this.setJMenuBar(Actions.menuActionSet.createMenuBar());
        this.toolBar = Actions.toolBarActionSet.createToolBar();
        this.leftPanel = new JTabbedPane();
        this.detailsView = new DetailsView();
        this.leftPanel.add((Component)((Object)this.detailsView), "Details");
        this.propertiesView = new PropertiesView();
        this.leftPanel.add((Component)((Object)this.propertiesView), "Properties");
        this.editorsPanel = new EditorsPanel();
        this.statusBar = new StatusBar();
        this.configureLayout(this.layout);
    }

    private void configureLayout(WorkbenchLayout layout) {
        int splitOrientation = 1;
        boolean leftOrTop = true;
        switch (layout) {
            case LEFT: 
            case RIGHT: {
                splitOrientation = 1;
                break;
            }
            case TOP: 
            case BOTTOM: {
                splitOrientation = 0;
            }
        }
        switch (layout) {
            case LEFT: 
            case TOP: {
                leftOrTop = true;
                break;
            }
            case RIGHT: 
            case BOTTOM: {
                leftOrTop = false;
            }
        }
        this.splitPane = new JSplitPane(splitOrientation);
        if (leftOrTop) {
            this.splitPane.add(this.leftPanel);
            this.splitPane.add((Component)this.editorsPanel);
        } else {
            this.splitPane.add((Component)this.editorsPanel);
            this.splitPane.add(this.leftPanel);
        }
        this.splitPane.setDividerLocation(this.leftPanelSize);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.statusBar, "South");
    }

    private Workspace openWorkspace() {
        Workspace workspace = WorkspaceManager.getDefault().getWorkspace();
        return workspace;
    }

    private void createWelcomeView() {
        WelcomeEditor view = new WelcomeEditor();
        this.editorsPanel.addEditor((AbstractEditor)view);
    }

    private void createDemoView() {
        HeatmapDemoEditor demoView = new HeatmapDemoEditor(40, 12);
        this.editorsPanel.addEditor((AbstractEditor)demoView);
    }

    public void start() {
        this.createWelcomeView();
        this.editorsPanel.setSelectedIndex(0);
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    public void setLeftPanelVisible(boolean visible) {
        boolean prevVisible = this.leftPanel.isVisible();
        if (prevVisible != visible) {
            if (!visible) {
                this.leftPanelSize = this.splitPane.getDividerLocation();
            } else {
                this.splitPane.setDividerLocation(this.leftPanelSize);
            }
            this.leftPanel.setVisible(visible);
        }
    }

    public NavigatorPanel getNavigatorPanel() {
        return this.navPanel;
    }

    public EditorsPanel getEditorsPanel() {
        return this.editorsPanel;
    }

    public DetailsView getDetailsView() {
        return this.detailsView;
    }

    public PropertiesView getPropertiesView() {
        return this.propertiesView;
    }

    public void setStatusText(String text) {
        this.statusBar.setText(text);
        this.repaint();
    }

    @Deprecated
    public IProgressMonitor createMonitor() {
        return this.statusBar.createMonitor();
    }

    public void refresh() {
    }

    static {
        if (appVersion == null) {
            appVersion = "SNAPSHOT";
        }
    }

    public static enum WorkbenchLayout {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

