/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.panels.decorator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.decorator.impl.ZScoreElementDecorator;
import org.gitools.ui.panels.decorator.AbstractElementDecoratorPanel;
import org.gitools.ui.panels.decorator.IndexedProperty;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;

public class ZScoreElementDecoratorPanel
extends AbstractElementDecoratorPanel {
    private static final long serialVersionUID = -7443053984962647946L;
    private List<IndexedProperty> valueProperties;
    private List<IndexedProperty> corrValueProperties;
    private ZScoreElementDecorator decorator;
    private JComboBox valueCb;
    private JCheckBox showCorrChkBox;
    private JComboBox corrValueCb;
    private JTextField sigLevelTb;
    private ColorChooserLabel lminColorCc;
    private ColorChooserLabel lmaxColorCc;
    private ColorChooserLabel rminColorCc;
    private ColorChooserLabel rmaxColorCc;
    private ColorChooserLabel nsigColorCc;
    private ColorChooserLabel emptyCc;

    public ZScoreElementDecoratorPanel(Heatmap model) {
        super(model);
        this.decorator = (ZScoreElementDecorator)model.getActiveCellDecorator();
        IElementAdapter adapter = this.decorator.getAdapter();
        int numProps = adapter.getPropertyCount();
        this.valueProperties = new ArrayList<IndexedProperty>();
        this.corrValueProperties = new ArrayList<IndexedProperty>();
        for (int i = 0; i < numProps; ++i) {
            IElementAttribute property = adapter.getProperty(i);
            if (property.getId().endsWith("z-score")) {
                this.valueProperties.add(new IndexedProperty(i, property));
            }
            if (!property.getId().startsWith("corrected")) continue;
            this.corrValueProperties.add(new IndexedProperty(i, property));
        }
        if (this.valueProperties.size() == 0) {
            this.loadAllProperties(this.valueProperties, adapter);
            this.loadAllProperties(this.corrValueProperties, adapter);
        } else if (this.corrValueProperties.size() == 0) {
            this.loadAllProperties(this.corrValueProperties, adapter);
        }
        this.createComponents();
    }

    private void createComponents() {
        this.valueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.valueProperties.toArray()));
        this.valueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ZScoreElementDecoratorPanel.this.valueChanged();
                }
            }
        });
        this.showCorrChkBox = new JCheckBox();
        this.showCorrChkBox.setText("Filter sig. by");
        this.showCorrChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZScoreElementDecoratorPanel.this.showCorrectionChecked();
            }
        });
        this.corrValueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.corrValueProperties.toArray()));
        this.corrValueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ZScoreElementDecoratorPanel.this.corrValueChanged();
                }
            }
        });
        this.sigLevelTb = new JTextField(Double.toString(this.decorator.getSignificanceLevel()));
        this.sigLevelTb.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ZScoreElementDecoratorPanel.this.sigLevelChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ZScoreElementDecoratorPanel.this.sigLevelChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ZScoreElementDecoratorPanel.this.sigLevelChanged();
            }
        });
        this.lminColorCc = new ColorChooserLabel(this.decorator.getLeftMinColor());
        this.lminColorCc.setToolTipText("Left side lowest value color");
        this.lminColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setLeftMinColor(color);
            }
        });
        this.lmaxColorCc = new ColorChooserLabel(this.decorator.getLeftMaxColor());
        this.lmaxColorCc.setToolTipText("Left side greatest value color");
        this.lmaxColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setLeftMaxColor(color);
            }
        });
        this.nsigColorCc = new ColorChooserLabel(this.decorator.getNonSignificantColor());
        this.nsigColorCc.setToolTipText("Non significant value color");
        this.nsigColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setNonSignificantColor(color);
            }
        });
        this.rminColorCc = new ColorChooserLabel(this.decorator.getRightMinColor());
        this.rminColorCc.setToolTipText("Right side lowest value color");
        this.rminColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setRightMinColor(color);
            }
        });
        this.rmaxColorCc = new ColorChooserLabel(this.decorator.getRightMaxColor());
        this.rmaxColorCc.setToolTipText("Right side greatest value color");
        this.rmaxColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setRightMaxColor(color);
            }
        });
        this.emptyCc = new ColorChooserLabel(this.decorator.getEmptyColor());
        this.emptyCc.setToolTipText("Empty cell color");
        this.emptyCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ZScoreElementDecoratorPanel.this.decorator.setEmptyColor(color);
            }
        });
        this.refresh();
        Dimension boxSpace = new Dimension(3, 3);
        this.setLayout(new FlowLayout(0));
        this.add(new JLabel("Value"));
        this.add(this.valueCb);
        this.add(this.showCorrChkBox);
        this.add(this.corrValueCb);
        this.add(new JLabel("Sig. level"));
        this.add(this.sigLevelTb);
        Box box01 = new Box(0);
        box01.add((Component)this.lminColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.lmaxColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.nsigColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.rminColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.rmaxColorCc);
        this.add(box01);
        Box box02 = new Box(0);
        box02.add(new JLabel("Empty"));
        box02.add(Box.createRigidArea(boxSpace));
        box02.add((Component)this.emptyCc);
        this.add(box02);
    }

    private void refresh() {
        int i;
        for (i = 0; i < this.valueProperties.size(); ++i) {
            if (this.valueProperties.get(i).getIndex() != this.decorator.getValueIndex()) continue;
            this.valueCb.setSelectedIndex(i);
        }
        this.getTable().setSelectedPropertyIndex(this.decorator.getValueIndex());
        this.showCorrChkBox.setSelected(this.decorator.getUseCorrection());
        this.corrValueCb.setEnabled(this.decorator.getUseCorrection());
        for (i = 0; i < this.corrValueProperties.size(); ++i) {
            if (this.corrValueProperties.get(i).getIndex() != this.decorator.getCorrectedValueIndex()) continue;
            this.corrValueCb.setSelectedIndex(i);
        }
    }

    private void valueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.valueCb.getSelectedItem();
        this.model.changeActiveCellDecorator(propAdapter.getIndex());
        this.changeDecorator();
        this.decorator.setValueIndex(propAdapter.getIndex());
        this.getTable().setSelectedPropertyIndex(propAdapter.getIndex());
    }

    private void changeDecorator() {
        this.decorator = (ZScoreElementDecorator)this.model.getActiveCellDecorator();
        this.lminColorCc.setColor(this.decorator.getLeftMinColor());
        this.lmaxColorCc.setColor(this.decorator.getLeftMaxColor());
        this.nsigColorCc.setColor(this.decorator.getNonSignificantColor());
        this.rminColorCc.setColor(this.decorator.getRightMinColor());
        this.rmaxColorCc.setColor(this.decorator.getRightMaxColor());
        this.sigLevelTb.setText(Double.toString(this.decorator.getSignificanceLevel()));
        this.corrValueCb.setSelectedIndex(this.decorator.getCorrectedValueIndex());
    }

    private void showCorrectionChecked() {
        this.decorator.setUseCorrection(this.showCorrChkBox.isSelected());
        this.corrValueCb.setEnabled(this.showCorrChkBox.isSelected());
    }

    protected void corrValueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.corrValueCb.getSelectedItem();
        this.decorator.setCorrectedValueIndex(propAdapter.getIndex());
    }

    protected void sigLevelChanged() {
        try {
            double value = Double.parseDouble(this.sigLevelTb.getText());
            this.decorator.setSignificanceLevel(value);
            AppFrame.instance().setStatusText("Significance level changed to " + value);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid value.");
        }
    }
}

