/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.panels.decorator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.decorator.impl.PValueElementDecorator;
import org.gitools.ui.panels.decorator.AbstractElementDecoratorPanel;
import org.gitools.ui.panels.decorator.IndexedProperty;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;

public class PValueElementDecoratorPanel
extends AbstractElementDecoratorPanel {
    private static final long serialVersionUID = -7443053984962647946L;
    private List<IndexedProperty> valueProperties;
    private List<IndexedProperty> corrValueProperties;
    private PValueElementDecorator decorator = (PValueElementDecorator)this.getDecorator();
    private JComboBox valueCb;
    private JCheckBox showCorrChkBox;
    private JComboBox corrValueCb;
    private JTextField sigLevelTb;
    private ColorChooserLabel minColorCc;
    private ColorChooserLabel maxColorCc;
    private ColorChooserLabel nsigColorCc;
    private ColorChooserLabel emptyCc;

    public PValueElementDecoratorPanel(Heatmap model) {
        super(model);
        IElementAdapter adapter = this.decorator.getAdapter();
        int numProps = adapter.getPropertyCount();
        this.valueProperties = new ArrayList<IndexedProperty>();
        this.corrValueProperties = new ArrayList<IndexedProperty>();
        for (int i = 0; i < numProps; ++i) {
            IElementAttribute property = adapter.getProperty(i);
            if (property.getId().endsWith("p-value")) {
                this.valueProperties.add(new IndexedProperty(i, property));
            }
            if (!property.getId().startsWith("corrected")) continue;
            this.corrValueProperties.add(new IndexedProperty(i, property));
        }
        if (this.valueProperties.size() == 0) {
            this.loadAllProperties(this.valueProperties, adapter);
            this.loadAllProperties(this.corrValueProperties, adapter);
        } else if (this.corrValueProperties.size() == 0) {
            this.loadAllProperties(this.corrValueProperties, adapter);
        }
        this.createComponents();
    }

    private void createComponents() {
        this.valueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.valueProperties.toArray()));
        this.valueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PValueElementDecoratorPanel.this.valueChanged();
                }
            }
        });
        this.showCorrChkBox = new JCheckBox();
        this.showCorrChkBox.setText("Filter sig. by");
        this.showCorrChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PValueElementDecoratorPanel.this.showCorrectionChecked();
            }
        });
        this.corrValueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.corrValueProperties.toArray()));
        this.corrValueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PValueElementDecoratorPanel.this.corrValueChanged();
                }
            }
        });
        this.sigLevelTb = new JTextField(Double.toString(this.decorator.getSignificanceLevel()));
        this.sigLevelTb.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PValueElementDecoratorPanel.this.sigLevelChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PValueElementDecoratorPanel.this.sigLevelChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PValueElementDecoratorPanel.this.sigLevelChanged();
            }
        });
        this.minColorCc = new ColorChooserLabel(this.decorator.getMinColor());
        this.minColorCc.setToolTipText("Lower significant p-value color");
        this.minColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                PValueElementDecoratorPanel.this.decorator.setMinColor(color);
            }
        });
        this.maxColorCc = new ColorChooserLabel(this.decorator.getMaxColor());
        this.maxColorCc.setToolTipText("Greater significant p-value color");
        this.maxColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                PValueElementDecoratorPanel.this.decorator.setMaxColor(color);
            }
        });
        this.nsigColorCc = new ColorChooserLabel(this.decorator.getNonSignificantColor());
        this.nsigColorCc.setToolTipText("Non significant p-value color");
        this.nsigColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                PValueElementDecoratorPanel.this.decorator.setNonSignificantColor(color);
            }
        });
        this.emptyCc = new ColorChooserLabel(this.decorator.getEmptyColor());
        this.emptyCc.setToolTipText("Empty cell color");
        this.emptyCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                PValueElementDecoratorPanel.this.decorator.setEmptyColor(color);
            }
        });
        this.refresh();
        Dimension boxSpace = new Dimension(3, 3);
        this.setLayout(new FlowLayout(0));
        this.add(new JLabel("Value"));
        this.add(this.valueCb);
        this.add(this.showCorrChkBox);
        this.add(this.corrValueCb);
        Box box01 = new Box(0);
        box01.add(new JLabel("Sig. level"));
        box01.add(Box.createRigidArea(boxSpace));
        box01.add(this.sigLevelTb);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.minColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.maxColorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.nsigColorCc);
        this.add(box01);
        this.add(new JLabel("Empty"));
        this.add((Component)this.emptyCc);
    }

    private void refresh() {
        int i;
        for (i = 0; i < this.valueProperties.size(); ++i) {
            if (this.valueProperties.get(i).getIndex() != this.decorator.getValueIndex()) continue;
            this.valueCb.setSelectedIndex(i);
        }
        this.getTable().setSelectedPropertyIndex(this.decorator.getValueIndex());
        this.showCorrChkBox.setSelected(this.decorator.getUseCorrection());
        this.corrValueCb.setEnabled(this.decorator.getUseCorrection());
        for (i = 0; i < this.corrValueProperties.size(); ++i) {
            if (this.corrValueProperties.get(i).getIndex() != this.decorator.getCorrectedValueIndex()) continue;
            this.corrValueCb.setSelectedIndex(i);
        }
    }

    private void valueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.valueCb.getSelectedItem();
        this.decorator.setValueIndex(propAdapter.getIndex());
        this.model.changeActiveCellDecorator(propAdapter.getIndex());
        this.changeDecorator();
        this.decorator.setValueIndex(propAdapter.getIndex());
        this.getTable().setSelectedPropertyIndex(propAdapter.getIndex());
        int corrIndex = MatrixUtils.correctedValueIndex((IElementAdapter)this.decorator.getAdapter(), (IElementAttribute)propAdapter.getProperty());
        if (corrIndex >= 0) {
            this.decorator.setCorrectedValueIndex(corrIndex);
        }
        this.refresh();
    }

    private void changeDecorator() {
        this.decorator = (PValueElementDecorator)this.model.getActiveCellDecorator();
        this.minColorCc.setColor(this.decorator.getMinColor());
        this.maxColorCc.setColor(this.decorator.getMaxColor());
        this.emptyCc.setColor(this.decorator.getEmptyColor());
        this.nsigColorCc.setColor(this.decorator.getNonSignificantColor());
        this.sigLevelTb.setText(Double.toString(this.decorator.getSignificanceLevel()));
        this.minColorCc.setColor(this.decorator.getMinColor());
        this.maxColorCc.setColor(this.decorator.getMaxColor());
        this.emptyCc.setColor(this.decorator.getEmptyColor());
        this.sigLevelTb.setText(Double.toString(this.decorator.getSignificanceLevel()));
    }

    private void showCorrectionChecked() {
        this.decorator.setUseCorrection(this.showCorrChkBox.isSelected());
        this.corrValueCb.setEnabled(this.showCorrChkBox.isSelected());
    }

    protected void corrValueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.corrValueCb.getSelectedItem();
        this.decorator.setCorrectedValueIndex(propAdapter.getIndex());
    }

    protected void sigLevelChanged() {
        try {
            double value = Double.parseDouble(this.sigLevelTb.getText());
            this.decorator.setSignificanceLevel(value);
            AppFrame.instance().setStatusText("Significance level changed to " + value);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid value.");
        }
    }
}

