/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.panels.decorator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.impl.LinearTwoSidedElementDecorator;
import org.gitools.ui.panels.decorator.AbstractElementDecoratorPanel;
import org.gitools.ui.panels.decorator.IndexedProperty;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;

public class LinearTwoSidedElementDecoratorPanel
extends AbstractElementDecoratorPanel {
    private static final long serialVersionUID = 8422331422677024364L;
    private LinearTwoSidedElementDecorator decorator;
    private JComboBox valueCb;
    private JTextField minValTxt;
    private JTextField maxValTxt;
    private JTextField midValTxt;
    private ColorChooserLabel minColorCc;
    private ColorChooserLabel midColorCc;
    private ColorChooserLabel maxColorCc;
    private ColorChooserLabel emptyCc;

    public LinearTwoSidedElementDecoratorPanel(Heatmap model) {
        super(model);
        this.decorator = (LinearTwoSidedElementDecorator)model.getActiveCellDecorator();
        IElementAdapter adapter = this.decorator.getAdapter();
        this.valueProperties = new ArrayList();
        this.loadAllProperties(this.valueProperties, adapter);
        this.createComponents();
    }

    private void createComponents() {
        this.valueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.valueProperties.toArray()));
        this.valueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LinearTwoSidedElementDecoratorPanel.this.valueChanged();
                }
            }
        });
        this.minValTxt = new JTextField(Double.toString(this.decorator.getMinValue()));
        this.minValTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.minValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.minValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.minValueChanged();
            }
        });
        this.minColorCc = new ColorChooserLabel(this.decorator.getMinColor());
        this.minColorCc.setToolTipText("Minimum value color");
        this.minColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                LinearTwoSidedElementDecoratorPanel.this.decorator.setMinColor(color);
            }
        });
        this.midValTxt = new JTextField(Double.toString(this.decorator.getMidValue()));
        this.midValTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.midValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.midValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.midValueChanged();
            }
        });
        this.midColorCc = new ColorChooserLabel(this.decorator.getMidColor());
        this.midColorCc.setToolTipText("Middle value color");
        this.midColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                LinearTwoSidedElementDecoratorPanel.this.decorator.setMidColor(color);
            }
        });
        this.maxValTxt = new JTextField(Double.toString(this.decorator.getMaxValue()));
        this.maxValTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.maxValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.maxValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LinearTwoSidedElementDecoratorPanel.this.maxValueChanged();
            }
        });
        this.maxColorCc = new ColorChooserLabel(this.decorator.getMaxColor());
        this.maxColorCc.setToolTipText("Maximum value color");
        this.maxColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                LinearTwoSidedElementDecoratorPanel.this.decorator.setMaxColor(color);
            }
        });
        this.emptyCc = new ColorChooserLabel(this.decorator.getEmptyColor());
        this.emptyCc.setToolTipText("Empty cell color");
        this.emptyCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                LinearTwoSidedElementDecoratorPanel.this.decorator.setEmptyColor(color);
            }
        });
        this.refresh();
        Dimension boxSpace = new Dimension(3, 3);
        this.setLayout(new FlowLayout(0));
        this.add(new JLabel("Value"));
        this.add(this.valueCb);
        Box box01 = new Box(0);
        box01.add(new JLabel(" Min"));
        box01.add(Box.createRigidArea(boxSpace));
        box01.add(this.minValTxt);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.minColorCc);
        this.add(box01);
        Box box02 = new Box(2);
        box02.add(new JLabel(" Mid"));
        box02.add(Box.createRigidArea(boxSpace));
        box02.add(this.midValTxt);
        box02.add(Box.createRigidArea(boxSpace));
        box02.add((Component)this.midColorCc);
        this.add(box02);
        Box box03 = new Box(2);
        box03.add(new JLabel(" Max"));
        box03.add(Box.createRigidArea(boxSpace));
        box03.add(this.maxValTxt);
        box03.add(Box.createRigidArea(boxSpace));
        box03.add((Component)this.maxColorCc);
        this.add(box03);
        Box box04 = new Box(2);
        box04.add(new JLabel(" Empty"));
        box04.add(Box.createRigidArea(boxSpace));
        box04.add((Component)this.emptyCc);
        this.add(box04);
    }

    private void refresh() {
        for (int i = 0; i < this.valueProperties.size(); ++i) {
            if (((IndexedProperty)this.valueProperties.get(i)).getIndex() != this.decorator.getValueIndex()) continue;
            this.valueCb.setSelectedIndex(i);
        }
        this.getTable().setSelectedPropertyIndex(this.decorator.getValueIndex());
    }

    private void valueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.valueCb.getSelectedItem();
        this.model.changeActiveCellDecorator(propAdapter.getIndex());
        this.changeDecorator();
        this.decorator.setValueIndex(propAdapter.getIndex());
        this.getTable().setSelectedPropertyIndex(propAdapter.getIndex());
    }

    private void changeDecorator() {
        this.decorator = (LinearTwoSidedElementDecorator)this.model.getActiveCellDecorator();
        this.minColorCc.setColor(this.decorator.getMinColor());
        this.midColorCc.setColor(this.decorator.getMidColor());
        this.maxColorCc.setColor(this.decorator.getMaxColor());
        this.emptyCc.setColor(this.decorator.getEmptyColor());
        this.minValTxt.setText(Double.toString(this.decorator.getMinValue()));
        this.midValTxt.setText(Double.toString(this.decorator.getMidValue()));
        this.maxValTxt.setText(Double.toString(this.decorator.getMaxValue()));
    }

    protected void minValueChanged() {
        try {
            double value = Double.parseDouble(this.minValTxt.getText());
            this.decorator.setMinValue(value);
            AppFrame.instance().setStatusText("Minimum value changed to " + value);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid value.");
        }
    }

    protected void midValueChanged() {
        try {
            double value = Double.parseDouble(this.midValTxt.getText());
            this.decorator.setMidValue(value);
            AppFrame.instance().setStatusText("Middle value changed to " + value);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid value.");
        }
    }

    protected void maxValueChanged() {
        try {
            double value = Double.parseDouble(this.maxValTxt.getText());
            this.decorator.setMaxValue(value);
            AppFrame.instance().setStatusText("Maximum value changed to " + value);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid value.");
        }
    }
}

