/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.panels.decorator;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.impl.BinaryElementDecorator;
import org.gitools.ui.panels.decorator.AbstractElementDecoratorPanel;
import org.gitools.ui.panels.decorator.IndexedProperty;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;

public class BinaryElementDecoratorPanel
extends AbstractElementDecoratorPanel {
    private static final long serialVersionUID = -930914489603614155L;
    private BinaryElementDecorator decorator = (BinaryElementDecorator)this.getDecorator();
    private JComboBox valueCb;
    private JComboBox cmpCb;
    private JTextField cutoffTf;
    private ColorChooserLabel colorCc;
    private ColorChooserLabel nonSigColorCc;
    private ColorChooserLabel emptyCc;

    public BinaryElementDecoratorPanel(Heatmap model) {
        super(model);
        IElementAdapter adapter = this.decorator.getAdapter();
        this.valueProperties = new ArrayList();
        this.loadAllProperties(this.valueProperties, adapter);
        this.createComponents();
    }

    private void createComponents() {
        this.valueCb = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.valueProperties.toArray()));
        this.valueCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BinaryElementDecoratorPanel.this.valueChanged();
                }
            }
        });
        this.cmpCb = new JComboBox<CutoffCmp>(CutoffCmp.comparators);
        this.cmpCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BinaryElementDecoratorPanel.this.cmpChanged();
                }
            }
        });
        this.cutoffTf = new JTextField(Double.toString(this.decorator.getCutoff()));
        this.cutoffTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                BinaryElementDecoratorPanel.this.cutoffChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BinaryElementDecoratorPanel.this.cutoffChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BinaryElementDecoratorPanel.this.cutoffChanged();
            }
        });
        this.colorCc = new ColorChooserLabel(this.decorator.getColor());
        this.colorCc.setToolTipText("Condition color");
        this.colorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                BinaryElementDecoratorPanel.this.decorator.setColor(color);
            }
        });
        this.nonSigColorCc = new ColorChooserLabel(this.decorator.getNonSignificantColor());
        this.nonSigColorCc.setToolTipText("Non condition color");
        this.nonSigColorCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                BinaryElementDecoratorPanel.this.decorator.setNonSignificantColor(color);
            }
        });
        this.emptyCc = new ColorChooserLabel(this.decorator.getEmptyColor());
        this.emptyCc.setToolTipText("Empty cell color");
        this.emptyCc.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                BinaryElementDecoratorPanel.this.decorator.setEmptyColor(color);
            }
        });
        this.refresh();
        Dimension boxSpace = new Dimension(3, 3);
        this.setLayout(new FlowLayout(0));
        this.add(new JLabel("Value"));
        this.add(this.valueCb);
        Box box01 = new Box(0);
        box01.add(this.cmpCb);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add(this.cutoffTf);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.colorCc);
        box01.add(Box.createRigidArea(boxSpace));
        box01.add((Component)this.nonSigColorCc);
        this.add(box01);
        this.add(new JLabel("Empty"));
        this.add((Component)this.emptyCc);
    }

    private void refresh() {
        for (int i = 0; i < this.valueProperties.size(); ++i) {
            if (((IndexedProperty)this.valueProperties.get(i)).getIndex() != this.decorator.getValueIndex()) continue;
            this.valueCb.setSelectedIndex(i);
        }
        this.getTable().setSelectedPropertyIndex(this.decorator.getValueIndex());
        CutoffCmp cmp = this.decorator.getCutoffCmp();
        for (int i = 0; i < this.cmpCb.getItemCount(); ++i) {
            CutoffCmp cc = (CutoffCmp)this.cmpCb.getItemAt(i);
            if (!cc.equals(cmp)) continue;
            this.cmpCb.setSelectedIndex(i);
        }
    }

    private void valueChanged() {
        IndexedProperty propAdapter = (IndexedProperty)this.valueCb.getSelectedItem();
        this.model.changeActiveCellDecorator(propAdapter.getIndex());
        this.changeDecorator();
        this.decorator.setValueIndex(propAdapter.getIndex());
        this.getTable().setSelectedPropertyIndex(propAdapter.getIndex());
    }

    private void changeDecorator() {
        this.decorator = (BinaryElementDecorator)this.model.getActiveCellDecorator();
        this.colorCc.setColor(this.decorator.getColor());
        this.nonSigColorCc.setColor(this.decorator.getNonSignificantColor());
        this.emptyCc.setColor(this.decorator.getEmptyColor());
        this.cutoffTf.setText(Double.toString(this.decorator.getCutoff()));
        this.cmpCb.setSelectedItem(this.decorator.getCutoffCmp());
    }

    protected void cmpChanged() {
        CutoffCmp cc = (CutoffCmp)this.cmpCb.getSelectedItem();
        this.decorator.setCutoffCmp(cc);
    }

    protected void cutoffChanged() {
        try {
            double cutoff = Double.parseDouble(this.cutoffTf.getText());
            this.decorator.setCutoff(cutoff);
            AppFrame.instance().setStatusText("Cutoff changed to " + cutoff);
        }
        catch (Exception e) {
            AppFrame.instance().setStatusText("Invalid cutoff.");
        }
    }
}

