/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.modules.wizard;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.gitools.modules.importer.ModuleCategory;
import org.gitools.modules.importer.ModulesImporter;
import org.gitools.modules.importer.Organism;
import org.gitools.modules.importer.Version;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.wizard.common.FilteredListPage;

public class ModulesOrganismPage
extends FilteredListPage {
    private ModulesImporter importer;
    private ModuleCategory modCategory;
    private Version version;
    boolean loaded;

    public ModulesOrganismPage(ModulesImporter importer) {
        this.importer = importer;
        this.loaded = false;
        this.setTitle("Select organism");
    }

    public void updateControls() {
        super.updateControls();
        if (!this.loaded || this.modCategory != this.importer.getModuleCategory() || this.version != this.importer.getVersion()) {
            JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.begin("Getting available organisms ...", 1);
                        ModulesOrganismPage.this.modCategory = ModulesOrganismPage.this.importer.getModuleCategory();
                        ModulesOrganismPage.this.version = ModulesOrganismPage.this.importer.getVersion();
                        final Organism[] organisms = ModulesOrganismPage.this.importer.getOrganisms();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ModulesOrganismPage.this.setListData(organisms);
                                for (Organism o : organisms) {
                                    if (!o.getName().equals("homo sapiens")) continue;
                                    ModulesOrganismPage.this.setSelectedValue(o);
                                }
                                ModulesOrganismPage.this.loaded = true;
                            }
                        });
                        monitor.end();
                    }
                    catch (Exception ex) {
                        monitor.exception(ex);
                    }
                }
            });
        }
    }

    public void updateModel() {
        this.importer.setOrganism(this.getOrganism());
    }

    private Organism getOrganism() {
        return (Organism)this.getSelectedValue();
    }
}

