/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.modules.wizard;

import org.gitools.modules.importer.ModulesImporter;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.ui.modules.wizard.ModulesFeaturesPage;
import org.gitools.ui.modules.wizard.ModulesOrganismPage;
import org.gitools.ui.modules.wizard.ModulesSourcePage;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class ModulesImportWizard
extends AbstractWizard {
    private FileFormat[] supportedFormats = new FileFormat[]{FileFormats.MODULES_2C_MAP, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED};
    private ModulesImporter importer;
    private ModulesSourcePage moduleCategoryPage;
    private ModulesOrganismPage organismPage;
    private ModulesFeaturesPage featuresPage;
    private SaveFilePage saveFilePage;

    public ModulesImportWizard(ModulesImporter importer) {
        this.importer = importer;
        this.setTitle("Import modules...");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Modules.png", (int)96));
    }

    public void addPages() {
        this.moduleCategoryPage = new ModulesSourcePage(this.importer);
        this.addPage((IWizardPage)this.moduleCategoryPage);
        this.organismPage = new ModulesOrganismPage(this.importer);
        this.addPage((IWizardPage)this.organismPage);
        this.featuresPage = new ModulesFeaturesPage(this.importer);
        this.addPage((IWizardPage)this.featuresPage);
        this.saveFilePage = new SaveFilePage(){

            public void updateModel() {
                Settings.getDefault().setLastMapPath(this.getFolder());
            }
        };
        this.saveFilePage.setTitle("Select destination file");
        this.saveFilePage.setFolder(Settings.getDefault().getLastMapPath());
        this.saveFilePage.setFormats(this.supportedFormats);
        this.addPage((IWizardPage)this.saveFilePage);
    }

    public void pageEntered(IWizardPage page) {
        if (((Object)((Object)this.saveFilePage)).equals(page) && this.saveFilePage.getFileNameWithoutExtension().isEmpty()) {
            this.saveFilePage.setFileNameWithoutExtension(this.automaticFileName(this.importer));
        }
    }

    private String automaticFileName(ModulesImporter importer) {
        StringBuilder sb = new StringBuilder();
        sb.append(importer.getOrganism().getName().replace(' ', '_'));
        sb.append("__");
        sb.append(importer.getModuleCategory().getRef().replace(':', '_'));
        sb.append("__");
        sb.append(importer.getFeatureCategory().getRef().replace(':', '_'));
        return sb.toString();
    }

    public SaveFilePage getSaveFilePage() {
        return this.saveFilePage;
    }
}

