/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.modules.wizard;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.gitools.modules.importer.FeatureCategory;
import org.gitools.modules.importer.ModulesImporter;
import org.gitools.modules.importer.Organism;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.wizard.common.FilteredListPage;

public class ModulesFeaturesPage
extends FilteredListPage {
    private final ModulesImporter importer;
    private Organism organism;
    private boolean loaded;

    public ModulesFeaturesPage(ModulesImporter importer) {
        this.importer = importer;
        this.setTitle("Select Identifiers");
    }

    public void updateControls() {
        if (!this.loaded || this.organism != this.importer.getOrganism()) {
            JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.begin("Getting available identifiers ...", 1);
                        ModulesFeaturesPage.this.organism = ModulesFeaturesPage.this.importer.getOrganism();
                        final FeatureCategory[] features = ModulesFeaturesPage.this.importer.getFeatureCategories();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ModulesFeaturesPage.this.setListData(features);
                                for (FeatureCategory f : features) {
                                    if (!f.getRef().equals("ensembl:gene")) continue;
                                    ModulesFeaturesPage.this.setSelectedValue(f);
                                }
                                ModulesFeaturesPage.this.loaded = true;
                            }
                        });
                        monitor.end();
                    }
                    catch (Exception ex) {
                        monitor.exception(ex);
                    }
                }
            });
        }
    }

    public void updateModel() {
        this.importer.setFeatCategory(this.getFeatureCategory());
    }

    private FeatureCategory getFeatureCategory() {
        return (FeatureCategory)this.getSelectedValue();
    }
}

