/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.intogen.dialog;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;

public class IntogenImportDownloadDialog
extends JDialog {
    private String overwritenFiles;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JTextField folder;
    private JButton folderBtn;
    private DialogHeaderPanel headerPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JTextField namePrefix;
    private JButton okButton;
    private int returnStatus = 0;

    public IntogenImportDownloadDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.headerPanel.setTitle("Select name prefix and folder");
        this.headerPanel.setLeftLogo(IconUtils.getIconResource((String)"/img/intogen/IntOGenWebLogo.png"));
        this.headerPanel.setLeftLogoLink("http://www.intogen.org");
        this.headerPanel.setRightLogo((Icon)IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/IntogenImport.png", (int)96));
        this.namePrefix.setText("unnamed");
        this.namePrefix.setSelectionStart(0);
        this.namePrefix.setSelectionEnd(this.namePrefix.getDocument().getLength());
        this.namePrefix.requestFocusInWindow();
        this.folder.setText(Settings.getDefault().getLastExportPath());
        DocumentChangeListener documentListener = new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                boolean exists = IntogenImportDownloadDialog.this.checkFileExists();
                if (exists) {
                    IntogenImportDownloadDialog.this.headerPanel.setMessageStatus(MessageStatus.WARN);
                    IntogenImportDownloadDialog.this.headerPanel.setMessage("Files already exist and will be overwriten: " + IntogenImportDownloadDialog.this.getOverwritenFiles());
                }
            }
        };
        this.namePrefix.getDocument().addDocumentListener(documentListener);
        this.folder.getDocument().addDocumentListener(documentListener);
    }

    public DialogHeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public String getOverwritenFiles() {
        return this.overwritenFiles;
    }

    public void setOverwritenFiles(String overwritenFiles) {
        this.overwritenFiles = overwritenFiles;
    }

    public boolean checkFileExists() {
        return false;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public boolean isCancelled() {
        return this.returnStatus == 0;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.namePrefix = new JTextField();
        this.jLabel1 = new JLabel();
        this.folderBtn = new JButton();
        this.folder = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.headerPanel = new DialogHeaderPanel();
        this.setTitle("Download...");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IntogenImportDownloadDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntogenImportDownloadDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntogenImportDownloadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name prefix");
        this.folderBtn.setText("Browse...");
        this.folderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntogenImportDownloadDialog.this.folderBtnActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Folder");
        this.headerPanel.setMessage("");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(564, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 716, Short.MAX_VALUE).addComponent((Component)this.headerPanel, -1, 716, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namePrefix, -1, 529, Short.MAX_VALUE).addComponent(this.folder, -1, 529, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderBtn).addGap(9, 9, 9)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.headerPanel, -1, 110, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.namePrefix, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.folder, -2, -1, -2).addComponent(this.folderBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void folderBtnActionPerformed(ActionEvent evt) {
        File selPath = FileChooserUtils.selectPath("Select folder", this.folder.getText());
        if (selPath != null) {
            this.folder.setText(selPath.getAbsolutePath());
            Settings.getDefault().setLastExportPath(selPath.getAbsolutePath());
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public String getNamePrefix() {
        return this.namePrefix.getText();
    }

    public String getFolder() {
        return this.folder.getText();
    }
}

