/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.intogen.dialog;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gitools.intogen.IntogenService;
import org.gitools.intogen.IntogenServiceException;
import org.gitools.ui.intogen.dialog.IntogenImportDownloadDialog;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.DialogHeaderPanel;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.xml.sax.SAXException;

public class IntogenImportDialog
extends JDialog {
    private ImportType type;
    private DialogHeaderPanel headerPanel;
    private HtmlPanel htmlPanel;
    private SimpleHtmlRendererContext rcontext;

    public IntogenImportDialog(Window parent, ImportType type) {
        super(parent);
        this.type = type;
        this.setModal(true);
        this.setLocationByPlatform(true);
        this.setTitle("IntOGen import...");
        this.headerPanel = new DialogHeaderPanel();
        this.headerPanel.setTitle("www.intogen.org");
        this.headerPanel.setMessage("");
        this.headerPanel.setLeftLogo(IconUtils.getIconResource((String)"/img/intogen/IntOGenWebLogo.png"));
        this.headerPanel.setLeftLogoLink("http://www.intogen.org");
        this.headerPanel.setRightLogo((Icon)IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/IntogenImport.png", (int)96));
        this.htmlPanel = new HtmlPanel();
        SimpleUserAgentContext uagent = new SimpleUserAgentContext();
        this.rcontext = new SimpleHtmlRendererContext(this.htmlPanel, (UserAgentContext)uagent){

            public void submitForm(String method, final URL action, String target, String enctype, FormInput[] formInputs) {
                boolean startDownload = false;
                if (method.equalsIgnoreCase("post") && formInputs != null) {
                    for (FormInput fi : formInputs) {
                        if (!fi.getName().equalsIgnoreCase("download") || !fi.getTextValue().equalsIgnoreCase("true")) continue;
                        startDownload = true;
                        break;
                    }
                }
                if (!startDownload) {
                    super.submitForm(method, action, target, enctype, formInputs);
                    return;
                }
                IntogenImportDownloadDialog saveDlg = new IntogenImportDownloadDialog((Window)IntogenImportDialog.this);
                saveDlg.setVisible(true);
                if (saveDlg.isCancelled()) {
                    return;
                }
                final File folder = new File(saveDlg.getFolder());
                final String prefix = saveDlg.getNamePrefix();
                final ArrayList<String[]> properties = new ArrayList<String[]>(formInputs.length);
                for (FormInput fi : formInputs) {
                    properties.add(new String[]{fi.getName(), fi.getTextValue()});
                }
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            IntogenService.getDefault().queryFromPOST(folder, prefix, action, properties, monitor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IntogenImportDialog.this.setVisible(false);
                                }
                            });
                        }
                        catch (IntogenServiceException ex) {
                            monitor.exception(ex);
                        }
                    }
                });
            }

            protected void submitFormSync(String method, URL action, String target, String enctype, FormInput[] formInputs) throws IOException, SAXException {
                super.submitFormSync(method, action, target, enctype, formInputs);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IntogenImportDialog.this.htmlPanel.repaint();
                        IntogenImportDialog.this.repaint();
                    }
                });
            }

            public void setStatus(String message) {
                IntogenImportDialog.this.headerPanel.setMessageStatus(MessageStatus.INFO);
                IntogenImportDialog.this.headerPanel.setMessage(message);
            }

            public void error(String message, Throwable throwable) {
                int ret = JOptionPane.showConfirmDialog(AppFrame.instance(), "There was an error trying to conect to " + IntogenImportDialog.this.getUrl() + "\nPress OK to try again or Cancel to close this dialog and try later.", "Error", 2, 0);
                if (ret == 0) {
                    try {
                        IntogenImportDialog.this.rcontext.navigate(new URL(IntogenImportDialog.this.getUrl()), "_this");
                    }
                    catch (Exception ex) {
                        IntogenImportDialog.this.setVisible(false);
                        ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                        dlg.setVisible(true);
                    }
                } else {
                    IntogenImportDialog.this.setVisible(false);
                }
            }

            protected boolean isNavigationAsynchronous() {
                return false;
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.htmlPanel, "Center");
        this.setPreferredSize(new Dimension(780, 520));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    IntogenImportDialog.this.rcontext.navigate(IntogenImportDialog.this.getUrl());
                }
                catch (MalformedURLException ex) {
                    IntogenImportDialog.this.setVisible(false);
                    ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
                    dlg.setVisible(true);
                }
            }
        });
        this.pack();
    }

    private String getUrl() {
        switch (this.type) {
            case ONCODATA: {
                return Settings.getDefault().getIntogenDataUrl();
            }
            case ONCOMODULES: {
                return Settings.getDefault().getIntogenOncomodulesUrl();
            }
        }
        return null;
    }

    public static enum ImportType {
        ONCODATA,
        ONCOMODULES;

    }
}

