/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.utils.DocumentChangeListener;

public class HeatmapSearchPanel
extends JPanel {
    private static Highlighter.HighlightPainter redHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.RED);
    private Heatmap hm;
    private Pattern searchPat;
    private Color defaultSearchTextBgColor;
    private Color defaultSearchTextFgColor;
    private JCheckBox anyWordChk;
    private JButton closeBtn;
    private JCheckBox highlightAllChk;
    private JCheckBox matchCaseChk;
    private JButton nextBtn;
    private JButton prevBtn;
    private JTextField searchText;
    private JLabel textNotFoundLabel;

    public HeatmapSearchPanel(Heatmap hm) {
        this.hm = hm;
        this.initComponents();
        this.defaultSearchTextBgColor = this.searchText.getBackground();
        this.defaultSearchTextFgColor = this.searchText.getForeground();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                HeatmapSearchPanel.this.searchText.requestFocus();
            }
        });
        this.searchText.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                HeatmapSearchPanel.this.updateSearch();
            }
        });
        this.searchText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapSearchPanel.this.searchNext();
            }
        });
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapSearchPanel.this.searchPrev();
            }
        });
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapSearchPanel.this.searchNext();
            }
        });
        this.highlightAllChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HeatmapSearchPanel.this.updateHighlight();
            }
        });
        this.matchCaseChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapSearchPanel.this.updateSearch();
            }
        });
        this.anyWordChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapSearchPanel.this.updateSearch();
            }
        });
        this.setNotFound(false);
    }

    private void setNotFound(boolean b) {
        if (b) {
            this.searchText.setForeground(Color.RED);
            this.textNotFoundLabel.setVisible(true);
        } else {
            this.searchText.setForeground(this.defaultSearchTextFgColor);
            this.textNotFoundLabel.setVisible(false);
        }
    }

    private boolean checkMatch(IMatrixView mv, AnnotationMatrix am, String label) {
        if (this.searchPat.matcher(label).find()) {
            return true;
        }
        if (am == null) {
            return false;
        }
        int annRow = am.getRowIndex(label);
        if (annRow == -1) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < am.getColumnCount() && !found; ++i) {
            found = this.searchPat.matcher(am.getCell(annRow, i)).find();
        }
        return found;
    }

    private void updateSearch() {
        StringBuilder sb = new StringBuilder();
        if (this.anyWordChk.isSelected()) {
            String[] tokens = this.searchText.getText().split(" ");
            if (tokens.length > 0) {
                sb.append(Pattern.quote(tokens[0].trim()));
                for (int i = 1; i < tokens.length; ++i) {
                    sb.append("|").append(Pattern.quote(tokens[i].trim()));
                }
            }
        } else {
            sb.append(Pattern.quote(this.searchText.getText()));
        }
        this.searchPat = this.matchCaseChk.isSelected() ? Pattern.compile(sb.toString()) : Pattern.compile(sb.toString(), 2);
        this.setNotFound(false);
        this.updateHighlight();
    }

    private void updateHighlight() {
        IMatrixView mv = this.hm.getMatrixView();
        int leadRow = mv.getLeadSelectionRow();
        int leadCol = mv.getLeadSelectionColumn();
        HashSet<String> highlighted = new HashSet<String>();
        boolean found = false;
        if (leadRow == -1 && leadCol == -1) {
            leadRow = 0;
        }
        if (leadRow != -1) {
            if (this.highlightAllChk.isSelected()) {
                AnnotationMatrix am = this.hm.getRowDim().getAnnotations();
                int rowCount = mv.getRowCount();
                for (int index = 0; index < rowCount; ++index) {
                    String label = mv.getRowLabel(index);
                    if (!this.checkMatch(mv, am, label)) continue;
                    highlighted.add(label);
                }
                this.hm.getRowDim().setHighlightedLabels(highlighted);
            } else {
                this.hm.getRowDim().clearHighlightedLabels();
            }
        } else if (leadRow == -1 && leadCol != -1) {
            if (this.highlightAllChk.isSelected()) {
                AnnotationMatrix am = this.hm.getColumnDim().getAnnotations();
                int colCount = mv.getColumnCount();
                for (int index = 0; index < colCount; ++index) {
                    String label = mv.getColumnLabel(index);
                    if (!this.checkMatch(mv, am, label)) continue;
                    highlighted.add(label);
                }
                this.hm.getColumnDim().setHighlightedLabels(highlighted);
            } else {
                this.hm.getColumnDim().clearHighlightedLabels();
            }
        }
    }

    private void searchPrev() {
        IMatrixView mv = this.hm.getMatrixView();
        int leadRow = mv.getLeadSelectionRow();
        int leadCol = mv.getLeadSelectionColumn();
        boolean found = false;
        int rowCount = mv.getRowCount();
        if (leadRow == -1 && leadCol == -1) {
            leadRow = rowCount - 1;
        }
        if (leadRow != -1) {
            AnnotationMatrix am = this.hm.getRowDim().getAnnotations();
            int index = leadRow - 1;
            if (index < 0) {
                index = rowCount - 1;
            }
            while (index != leadRow && !(found = this.checkMatch(mv, am, mv.getRowLabel(index)))) {
                if (--index >= 0) continue;
                index = rowCount - 1;
            }
            if (index == leadRow) {
                found = this.checkMatch(mv, am, mv.getRowLabel(index));
            }
            mv.setLeadSelection(index, leadCol);
        } else if (leadRow == -1 && leadCol != -1) {
            AnnotationMatrix am = this.hm.getColumnDim().getAnnotations();
            int colCount = mv.getColumnCount();
            int index = leadCol - 1;
            if (index < 0) {
                index = colCount - 1;
            }
            while (index != leadCol && !(found = this.checkMatch(mv, am, mv.getColumnLabel(index)))) {
                if (--index >= 0) continue;
                index = colCount - 1;
            }
            if (index == leadCol) {
                found = this.checkMatch(mv, am, mv.getColumnLabel(index));
            }
            mv.setLeadSelection(leadRow, index);
        }
        this.setNotFound(!found);
    }

    private void searchNext() {
        IMatrixView mv = this.hm.getMatrixView();
        int leadRow = mv.getLeadSelectionRow();
        int leadCol = mv.getLeadSelectionColumn();
        boolean found = false;
        if (leadRow == -1 && leadCol == -1) {
            leadRow = 0;
        }
        if (leadRow != -1) {
            AnnotationMatrix am = this.hm.getRowDim().getAnnotations();
            int index = leadRow + 1;
            int rowCount = mv.getRowCount();
            if (index >= rowCount) {
                index = 0;
            }
            while (index != leadRow && !(found = this.checkMatch(mv, am, mv.getRowLabel(index)))) {
                if (++index < rowCount) continue;
                index = 0;
            }
            if (index == leadRow) {
                found = this.checkMatch(mv, am, mv.getRowLabel(index));
            }
            mv.setLeadSelection(index, leadCol);
        } else if (leadRow == -1 && leadCol != -1) {
            AnnotationMatrix am = this.hm.getColumnDim().getAnnotations();
            int index = leadCol + 1;
            int colCount = mv.getColumnCount();
            if (index >= colCount) {
                index = 0;
            }
            while (index != leadCol && !(found = this.checkMatch(mv, am, mv.getColumnLabel(index)))) {
                if (++index < colCount) continue;
                index = 0;
            }
            if (index == leadCol) {
                found = this.checkMatch(mv, am, mv.getColumnLabel(index));
            }
            mv.setLeadSelection(leadRow, index);
        }
        this.setNotFound(!found);
    }

    private void initComponents() {
        this.closeBtn = new JButton();
        this.searchText = new JTextField();
        this.prevBtn = new JButton();
        this.nextBtn = new JButton();
        this.highlightAllChk = new JCheckBox();
        this.matchCaseChk = new JCheckBox();
        this.textNotFoundLabel = new JLabel();
        this.anyWordChk = new JCheckBox();
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.closeBtn.setIcon(new ImageIcon(this.getClass().getResource("/img/SearchClose.png")));
        this.closeBtn.setFocusable(false);
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapSearchPanel.this.closeBtnActionPerformed(evt);
            }
        });
        this.prevBtn.setIcon(new ImageIcon(this.getClass().getResource("/img/SearchPrev.png")));
        this.prevBtn.setText("Previous");
        this.prevBtn.setFocusable(false);
        this.nextBtn.setIcon(new ImageIcon(this.getClass().getResource("/img/SearchNext.png")));
        this.nextBtn.setText("Next");
        this.nextBtn.setFocusable(false);
        this.nextBtn.setRequestFocusEnabled(false);
        this.highlightAllChk.setSelected(true);
        this.highlightAllChk.setText("Highlight all");
        this.highlightAllChk.setFocusable(false);
        this.highlightAllChk.setRequestFocusEnabled(false);
        this.matchCaseChk.setText("Match case");
        this.matchCaseChk.setFocusable(false);
        this.matchCaseChk.setRequestFocusEnabled(false);
        this.textNotFoundLabel.setIcon(new ImageIcon(this.getClass().getResource("/img/SearchNotFound.png")));
        this.textNotFoundLabel.setText("Text not found");
        this.anyWordChk.setText("Any word");
        this.anyWordChk.setFocusable(false);
        this.anyWordChk.setRequestFocusEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.closeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchText, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextBtn).addGap(18, 18, 18).addComponent(this.textNotFoundLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highlightAllChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.matchCaseChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.anyWordChk).addContainerGap(67, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeBtn).addComponent(this.searchText, -2, -1, -2).addComponent(this.prevBtn).addComponent(this.nextBtn).addComponent(this.highlightAllChk).addComponent(this.textNotFoundLabel).addComponent(this.matchCaseChk).addComponent(this.anyWordChk)));
    }

    private void closeBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

