/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel.properties;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.heatmap.header.HeatmapHierarchicalColoredLabelsHeader;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.idtype.IdType;
import org.gitools.idtype.IdTypeManager;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.heatmap.header.AddHeaderPage;
import org.gitools.ui.heatmap.header.coloredlabels.ColoredLabelsHeaderWizard;
import org.gitools.ui.heatmap.header.coloredlabels.HierarchicalColoredLabelsHeaderWizard;
import org.gitools.ui.heatmap.header.textlabels.TextLabelsHeaderWizard;
import org.gitools.ui.heatmap.panel.properties.HeatmapPropertiesAbstractPanel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.PageDialog;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.LogUtils;
import org.slf4j.LoggerFactory;

public class HeatmapPropertiesHeaderPanel
extends HeatmapPropertiesAbstractPanel {
    private boolean rowMode;
    private HeatmapDim hdim;
    private boolean updatingModel = false;
    private JButton annClear;
    private JTextField annFile;
    private JButton annFilter;
    private JButton annImport;
    private JButton annOpen;
    private JButton headerAddBtn;
    private ColorChooserLabel headerBgColor;
    private JButton headerDownBtn;
    private JButton headerEditBtn;
    private JList headerList;
    private JButton headerRemoveBtn;
    private JSpinner headerSize;
    private JButton headerUpBtn;
    private JCheckBox headerVisible;
    private JComboBox idTypeCb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public HeatmapPropertiesHeaderPanel(boolean rowMode) {
        this.rowMode = rowMode;
        this.initComponents();
        List idTypes = IdTypeManager.getDefault().getIdTypes();
        this.idTypeCb.setModel(new DefaultComboBoxModel<IdType>(idTypes.toArray(new IdType[idTypes.size()])));
        this.idTypeCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapPropertiesHeaderPanel.this.hdim.setIdType((IdType)HeatmapPropertiesHeaderPanel.this.idTypeCb.getSelectedItem());
            }
        });
        this.headerList.setModel(new DefaultListModel());
        this.headerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HeatmapPropertiesHeaderPanel.this.updateHeaderSelection();
            }
        });
        this.headerSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HeatmapPropertiesHeaderPanel.this.headerSizeChanged();
            }
        });
        this.headerVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapPropertiesHeaderPanel.this.headerVisibleChanged();
            }
        });
        this.headerBgColor.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                HeatmapPropertiesHeaderPanel.this.headerBgColorChanged();
            }
        });
    }

    @Override
    public void setHeatmap(Heatmap heatmap) {
        this.hdim = this.rowMode ? heatmap.getRowDim() : heatmap.getColumnDim();
        super.setHeatmap(heatmap);
    }

    @Override
    protected void initControls() {
    }

    @Override
    protected void updateControls() {
        this.updatingControls = true;
        this.idTypeCb.setSelectedItem(this.hdim.getIdType());
        this.updateAnnotations();
        this.updateHeaders();
        this.updateHeaderSelection();
        this.updatingControls = false;
    }

    private void updateAnnotations() {
        AnnotationMatrix annMatrix = this.hdim.getAnnotations();
        if (annMatrix != null) {
            this.annFile.setText(annMatrix.getTitle());
            this.setAnnotationControlsEnabled(true);
        } else {
            this.annFile.setText("");
            this.setAnnotationControlsEnabled(false);
        }
    }

    private void updateHeaders() {
        int index = this.headerList.getSelectedIndex();
        DefaultListModel m = (DefaultListModel)this.headerList.getModel();
        m.clear();
        for (HeatmapHeader h : this.hdim.getHeaders()) {
            m.addElement(h.getTitle());
        }
        this.headerList.setModel(m);
        if (index >= 0) {
            this.headerList.setSelectedIndex(index);
        } else if (!m.isEmpty()) {
            this.headerList.setSelectedIndex(0);
        }
    }

    private void updateHeaderSelection() {
        int index = this.headerList.getSelectedIndex();
        boolean sel = index >= 0;
        this.headerSize.setEnabled(sel);
        this.headerVisible.setEnabled(sel);
        this.headerBgColor.setEnabled(sel);
        this.headerEditBtn.setEnabled(sel);
        this.headerRemoveBtn.setEnabled(sel);
        this.headerUpBtn.setEnabled(sel && index > 0);
        this.headerDownBtn.setEnabled(sel && index < this.headerList.getModel().getSize() - 1);
        if (sel) {
            HeatmapHeader h = (HeatmapHeader)this.hdim.getHeaders().get(index);
            this.headerSize.setValue(h.getSize());
            this.headerVisible.setSelected(h.isVisible());
            this.headerBgColor.setColor(h.getBackgroundColor());
        }
    }

    private void headerSizeChanged() {
        int index = this.headerList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        SpinnerNumberModel m = (SpinnerNumberModel)this.headerSize.getModel();
        ((HeatmapHeader)this.hdim.getHeaders().get(index)).setSize(m.getNumber().intValue());
    }

    private void headerVisibleChanged() {
        int index = this.headerList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        ((HeatmapHeader)this.hdim.getHeaders().get(index)).setVisible(this.headerVisible.isSelected());
    }

    private void headerBgColorChanged() {
        int index = this.headerList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Color color = this.headerBgColor.getColor();
        ((HeatmapHeader)this.hdim.getHeaders().get(index)).setBackgroundColor(color);
    }

    private void setAnnotationControlsEnabled(boolean enabled) {
        JComponent[] components;
        for (JComponent c : components = new JComponent[]{this.annClear, this.annFilter}) {
            c.setEnabled(enabled);
        }
    }

    @Override
    protected void heatmapPropertyChange(PropertyChangeEvent evt) {
        if (this.updatingModel) {
            return;
        }
        Object src = evt.getSource();
        String pname = evt.getPropertyName();
        this.updatingControls = true;
        if (!src.equals(this.hm) && src.equals(this.hdim)) {
            if ("annotations".equals(pname)) {
                this.updateAnnotations();
            } else if ("headers".equals(pname)) {
                this.updateHeaders();
            }
        }
        this.updatingControls = false;
    }

    private File getSelectedPath() {
        JFileChooser fileChooser = new JFileChooser(Settings.getDefault().getLastAnnotationPath());
        fileChooser.setDialogTitle("Select file");
        fileChooser.setMinimumSize(new Dimension(800, 600));
        fileChooser.setPreferredSize(new Dimension(800, 600));
        int retval = fileChooser.showOpenDialog(AppFrame.instance());
        if (retval == 0) {
            Settings.getDefault().setLastAnnotationPath(fileChooser.getSelectedFile().getParent());
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private void initComponents() {
        this.jLabel9 = new JLabel();
        this.annFile = new JTextField();
        this.annOpen = new JButton();
        this.annImport = new JButton();
        this.annClear = new JButton();
        this.annFilter = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.headerList = new JList();
        this.jLabel1 = new JLabel();
        this.headerAddBtn = new JButton();
        this.headerRemoveBtn = new JButton();
        this.headerEditBtn = new JButton();
        this.headerUpBtn = new JButton();
        this.headerDownBtn = new JButton();
        this.jLabel2 = new JLabel();
        this.headerSize = new JSpinner();
        this.headerVisible = new JCheckBox();
        this.headerBgColor = new ColorChooserLabel();
        this.jLabel3 = new JLabel();
        this.idTypeCb = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.setPreferredSize(new Dimension(214, 730));
        this.jLabel9.setText("Annotations");
        this.annFile.setEditable(false);
        this.annFile.setFocusable(false);
        this.annOpen.setText("Load...");
        this.annOpen.setFocusable(false);
        this.annOpen.setMaximumSize(new Dimension(68, 25));
        this.annOpen.setMinimumSize(new Dimension(68, 25));
        this.annOpen.setPreferredSize(new Dimension(68, 25));
        this.annOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.annOpenActionPerformed(evt);
            }
        });
        this.annImport.setText("Import...");
        this.annImport.setEnabled(false);
        this.annImport.setFocusable(false);
        this.annImport.setMaximumSize(new Dimension(68, 25));
        this.annImport.setMinimumSize(new Dimension(68, 25));
        this.annImport.setPreferredSize(new Dimension(68, 25));
        this.annImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.annImportActionPerformed(evt);
            }
        });
        this.annClear.setText("Clear");
        this.annClear.setFocusable(false);
        this.annClear.setMaximumSize(new Dimension(68, 25));
        this.annClear.setMinimumSize(new Dimension(68, 25));
        this.annClear.setPreferredSize(new Dimension(68, 25));
        this.annClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.annClearActionPerformed(evt);
            }
        });
        this.annFilter.setText("Filter");
        this.annFilter.setToolTipText("Filter out elements without annotations");
        this.annFilter.setFocusable(false);
        this.annFilter.setMaximumSize(new Dimension(68, 25));
        this.annFilter.setMinimumSize(new Dimension(68, 25));
        this.annFilter.setPreferredSize(new Dimension(68, 25));
        this.annFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.annFilterActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.headerList);
        this.jLabel1.setText("Headers");
        this.headerAddBtn.setText("Add");
        this.headerAddBtn.setFocusable(false);
        this.headerAddBtn.setMaximumSize(new Dimension(39, 25));
        this.headerAddBtn.setMinimumSize(new Dimension(39, 25));
        this.headerAddBtn.setPreferredSize(new Dimension(39, 25));
        this.headerAddBtn.setRequestFocusEnabled(false);
        this.headerAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.headerAddBtnActionPerformed(evt);
            }
        });
        this.headerRemoveBtn.setText("Remove");
        this.headerRemoveBtn.setEnabled(false);
        this.headerRemoveBtn.setFocusable(false);
        this.headerRemoveBtn.setMaximumSize(new Dimension(69, 25));
        this.headerRemoveBtn.setMinimumSize(new Dimension(69, 25));
        this.headerRemoveBtn.setPreferredSize(new Dimension(69, 25));
        this.headerRemoveBtn.setRequestFocusEnabled(false);
        this.headerRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.headerRemoveBtnActionPerformed(evt);
            }
        });
        this.headerEditBtn.setText("Edit");
        this.headerEditBtn.setEnabled(false);
        this.headerEditBtn.setFocusable(false);
        this.headerEditBtn.setMaximumSize(new Dimension(38, 25));
        this.headerEditBtn.setMinimumSize(new Dimension(38, 25));
        this.headerEditBtn.setPreferredSize(new Dimension(38, 25));
        this.headerEditBtn.setRequestFocusEnabled(false);
        this.headerEditBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.headerEditBtnActionPerformed(evt);
            }
        });
        this.headerUpBtn.setText("Up");
        this.headerUpBtn.setEnabled(false);
        this.headerUpBtn.setFocusable(false);
        this.headerUpBtn.setMaximumSize(new Dimension(39, 25));
        this.headerUpBtn.setMinimumSize(new Dimension(39, 25));
        this.headerUpBtn.setPreferredSize(new Dimension(39, 25));
        this.headerUpBtn.setRequestFocusEnabled(false);
        this.headerUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.headerUpBtnActionPerformed(evt);
            }
        });
        this.headerDownBtn.setText("Down");
        this.headerDownBtn.setEnabled(false);
        this.headerDownBtn.setFocusable(false);
        this.headerDownBtn.setMaximumSize(new Dimension(69, 25));
        this.headerDownBtn.setMinimumSize(new Dimension(69, 25));
        this.headerDownBtn.setPreferredSize(new Dimension(69, 25));
        this.headerDownBtn.setRequestFocusEnabled(false);
        this.headerDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesHeaderPanel.this.headerDownBtnActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Size");
        this.headerSize.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)5));
        this.headerVisible.setText("Visible");
        this.headerBgColor.setEnabled(false);
        this.jLabel3.setText("Type of identifiers");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 261, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 237, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annOpen, -1, 71, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.annImport, -1, 71, Short.MAX_VALUE).addGap(95, 95, 95)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idTypeCb, 0, 237, Short.MAX_VALUE).addComponent(this.jLabel3)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addContainerGap(166, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(191, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annClear, -1, 71, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.annFilter, -1, 71, Short.MAX_VALUE).addGap(95, 95, 95)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annFile, -1, 237, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerSize, -2, 60, -2).addGap(18, 18, 18).addComponent(this.headerVisible).addGap(18, 26, Short.MAX_VALUE).addComponent((Component)this.headerBgColor, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.headerUpBtn, -1, -1, Short.MAX_VALUE).addComponent(this.headerAddBtn, -1, 61, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerDownBtn, -1, 93, Short.MAX_VALUE).addComponent(this.headerRemoveBtn, -1, 93, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerEditBtn, -2, 71, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idTypeCb, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addGap(12, 12, 12).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annFile, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.annOpen, -2, -1, -2).addComponent(this.annImport, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.annClear, -2, -1, -2).addComponent(this.annFilter, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.jSeparator1, -2, 10, -2).addGap(12, 12, 12).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerAddBtn, -2, -1, -2).addComponent(this.headerRemoveBtn, -2, -1, -2).addComponent(this.headerEditBtn, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerUpBtn, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.headerDownBtn, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.headerSize, -2, -1, -2).addComponent(this.headerVisible)).addComponent((Component)this.headerBgColor, -2, -1, -2)).addContainerGap(272, Short.MAX_VALUE)));
    }

    private void annOpenActionPerformed(ActionEvent evt) {
        try {
            File file = this.getSelectedPath();
            if (file != null) {
                AnnotationMatrix annMatrix = (AnnotationMatrix)PersistenceManager.getDefault().load(file, "application/gitools-matrix-annotation", (IProgressMonitor)new NullProgressMonitor());
                this.hdim.setAnnotations(annMatrix);
                this.annFile.setText(file.getName());
            }
        }
        catch (Exception ex) {
            LogUtils.logException(ex, LoggerFactory.getLogger(this.getClass()));
        }
    }

    private void annFilterActionPerformed(ActionEvent evt) {
        IMatrixView matrixView = this.hm.getMatrixView();
        int count = this.rowMode ? matrixView.getRowCount() : matrixView.getColumnCount();
        AnnotationMatrix annotations = this.hdim.getAnnotations();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            String element = this.rowMode ? matrixView.getRowLabel(i) : matrixView.getColumnLabel(i);
            int j = annotations.getRowIndex(element);
            if (j < 0) continue;
            indices.add(i);
        }
        int[] view = this.rowMode ? matrixView.getVisibleRows() : matrixView.getVisibleColumns();
        int[] newView = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            newView[i] = view[(Integer)indices.get(i)];
        }
        if (this.rowMode) {
            matrixView.setVisibleRows(newView);
        } else {
            matrixView.setVisibleColumns(newView);
        }
    }

    private void annClearActionPerformed(ActionEvent evt) {
        this.hdim.setAnnotations(null);
    }

    private void headerAddBtnActionPerformed(ActionEvent evt) {
        HeatmapTextLabelsHeader h;
        AddHeaderPage headerPage = new AddHeaderPage();
        PageDialog tdlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)headerPage);
        tdlg.setTitle("Header type selection");
        tdlg.setVisible(true);
        if (tdlg.isCancelled()) {
            return;
        }
        HeatmapTextLabelsHeader header = null;
        AbstractWizard wizard = null;
        Class<? extends HeatmapHeader> cls = headerPage.getHeaderClass();
        if (cls.equals(HeatmapTextLabelsHeader.class)) {
            h = new HeatmapTextLabelsHeader(this.hdim);
            wizard = new TextLabelsHeaderWizard(this.hdim, h);
            header = h;
        } else {
            h = new HeatmapColoredLabelsHeader(this.hdim);
            wizard = new ColoredLabelsHeaderWizard(this.hm, this.hdim, (HeatmapColoredLabelsHeader)h, this.rowMode);
            header = h;
        }
        WizardDialog wdlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wdlg.setTitle("Add header");
        wdlg.setVisible(true);
        if (wdlg.isCancelled()) {
            return;
        }
        this.hdim.addHeader((HeatmapHeader)header);
        this.updateHeaders();
    }

    private void headerEditBtnActionPerformed(ActionEvent evt) {
        int index = this.headerList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HeatmapHeader h = (HeatmapHeader)this.hdim.getHeaders().get(index);
        Class<?> cls = h.getClass();
        AbstractWizard wizard = null;
        if (HeatmapTextLabelsHeader.class.equals(cls)) {
            wizard = new TextLabelsHeaderWizard(this.hdim, (HeatmapTextLabelsHeader)h);
        } else if (HeatmapColoredLabelsHeader.class.equals(cls)) {
            ColoredLabelsHeaderWizard wiz = new ColoredLabelsHeaderWizard(this.hm, this.hdim, (HeatmapColoredLabelsHeader)h, this.rowMode);
            wiz.setEditionMode(true);
            wizard = wiz;
        } else if (HeatmapHierarchicalColoredLabelsHeader.class.equals(cls)) {
            wizard = new HierarchicalColoredLabelsHeaderWizard(this.hm, this.hdim, (HeatmapHierarchicalColoredLabelsHeader)h);
        }
        if (wizard == null) {
            return;
        }
        WizardDialog wdlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wdlg.setTitle("Edit header");
        wdlg.setVisible(true);
        this.updateHeaders();
    }

    private void headerUpBtnActionPerformed(ActionEvent evt) {
        int index = this.headerList.getSelectedIndex();
        if (index == -1 || index == 0) {
            return;
        }
        this.hdim.upHeader(index);
        this.headerList.setSelectedIndex(index - 1);
    }

    private void headerDownBtnActionPerformed(ActionEvent evt) {
        int index = this.headerList.getSelectedIndex();
        if (index == -1 || index >= this.headerList.getModel().getSize() - 1) {
            return;
        }
        this.hdim.downHeader(index);
        this.headerList.setSelectedIndex(index + 1);
    }

    private void headerRemoveBtnActionPerformed(ActionEvent evt) {
        int index = this.headerList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.hdim.removeHeader(index);
    }

    private void annImportActionPerformed(ActionEvent evt) {
    }

    private static class AnnAttr {
        private String name;

        public AnnAttr() {
        }

        public AnnAttr(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getPattern() {
            return "${" + this.name + "}";
        }

        public String toString() {
            return this.getName();
        }
    }
}

