/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorDescriptor;
import org.gitools.model.decorator.ElementDecoratorFactory;
import org.gitools.model.decorator.impl.PValueElementDecorator;
import org.gitools.model.decorator.impl.ZScoreElementDecorator;
import org.gitools.ui.heatmap.panel.properties.HeatmapPropertiesAbstractPanel;
import org.gitools.ui.panels.decorator.ElementDecoratorPanelFactory;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.component.ColorChooserLabel;
import org.gitools.ui.settings.decorators.DecoratorArchive;
import org.gitools.ui.settings.decorators.DecoratorArchivePersistance;
import org.gitools.ui.settings.decorators.LoadDecoratorDialog;
import org.gitools.ui.settings.decorators.SaveDecoratorDialog;

public class HeatmapPropertiesCellsPanel
extends HeatmapPropertiesAbstractPanel {
    private Map<ElementDecoratorDescriptor, ElementDecorator[]> decoratorCache = new HashMap<ElementDecoratorDescriptor, ElementDecorator[]>();
    private JComboBox cellDecorator;
    private JSpinner cellHeight;
    private JToggleButton cellSyncSize;
    private JSpinner cellWidth;
    private ColorChooserLabel columnsGridColor;
    private JCheckBox columnsGridEnabled;
    private JSpinner columnsGridSize;
    private JPanel decoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSeparator jSeparator1;
    private JButton loadScale;
    private ColorChooserLabel rowsGridColor;
    private JCheckBox rowsGridEnabled;
    private JSpinner rowsGridSize;
    private JButton saveScale;

    public HeatmapPropertiesCellsPanel() {
        this.initComponents();
    }

    @Override
    public void setHeatmap(Heatmap heatmap) {
        if (this.getHeatmap() != heatmap) {
            this.decoratorCache.clear();
        }
        super.setHeatmap(heatmap);
    }

    @Override
    protected void initControls() {
        this.rowsGridColor.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                if (!HeatmapPropertiesCellsPanel.this.updatingControls) {
                    HeatmapPropertiesCellsPanel.this.hm.getRowDim().setGridColor(color);
                }
            }
        });
        this.columnsGridColor.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                if (!HeatmapPropertiesCellsPanel.this.updatingControls) {
                    HeatmapPropertiesCellsPanel.this.hm.getColumnDim().setGridColor(color);
                }
            }
        });
        this.cellDecorator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!HeatmapPropertiesCellsPanel.this.updatingControls) {
                    HeatmapPropertiesCellsPanel.this.cellDecoratorChanged(e);
                }
            }
        });
    }

    @Override
    protected void updateControls() {
        this.updatingControls = true;
        HeatmapDim rdim = this.hm.getRowDim();
        HeatmapDim cdim = this.hm.getColumnDim();
        this.cellWidth.setValue(this.hm.getCellWidth());
        this.cellHeight.setValue(this.hm.getCellHeight());
        this.rowsGridEnabled.setSelected(rdim.isGridEnabled());
        this.rowsGridColor.setColor(rdim.getGridColor());
        this.rowsGridSize.setValue(rdim.getGridSize());
        this.columnsGridEnabled.setSelected(cdim.isGridEnabled());
        this.columnsGridColor.setColor(cdim.getGridColor());
        this.columnsGridSize.setValue(cdim.getGridSize());
        List descList = ElementDecoratorFactory.getDescriptors();
        ElementDecoratorDescriptor[] descriptors = new ElementDecoratorDescriptor[descList.size()];
        descList.toArray(descriptors);
        this.cellDecorator.setModel(new DefaultComboBoxModel<ElementDecoratorDescriptor>(descriptors));
        ElementDecoratorDescriptor descriptor = ElementDecoratorFactory.getDescriptor(this.hm.getActiveCellDecorator().getClass());
        this.cellDecorator.setSelectedItem(descriptor);
        this.changeDecoratorPanel(descriptor);
        this.updatingControls = false;
    }

    @Override
    protected void heatmapPropertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (evt.getSource().equals(this.hm)) {
            if ("cellSize".equals(pname)) {
                this.cellWidth.setValue(this.hm.getCellWidth());
                this.cellHeight.setValue(this.hm.getCellHeight());
            } else if ("cellDecorator".equals(pname) && evt.getOldValue().getClass().equals(evt.getNewValue().getClass())) {
                ElementDecoratorDescriptor descriptor = ElementDecoratorFactory.getDescriptor(this.hm.getActiveCellDecorator().getClass());
                this.changeDecoratorPanel(descriptor);
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.cellWidth = new JSpinner();
        this.jLabel4 = new JLabel();
        this.cellHeight = new JSpinner();
        this.cellSyncSize = new JToggleButton();
        this.rowsGridEnabled = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.rowsGridColor = new ColorChooserLabel();
        this.jLabel5 = new JLabel();
        this.rowsGridSize = new JSpinner();
        this.columnsGridEnabled = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.columnsGridColor = new ColorChooserLabel();
        this.jLabel6 = new JLabel();
        this.columnsGridSize = new JSpinner();
        this.jLabel7 = new JLabel();
        this.cellDecorator = new JComboBox();
        this.decoPanel = new JPanel();
        this.saveScale = new JButton();
        this.loadScale = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setPreferredSize(new Dimension(214, 651));
        this.jLabel3.setText("Width");
        this.cellWidth.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.cellWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.cellWidthStateChanged(evt);
            }
        });
        this.jLabel4.setText("Height");
        this.cellHeight.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.cellHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.cellHeightStateChanged(evt);
            }
        });
        this.cellSyncSize.setIcon(new ImageIcon(this.getClass().getResource("/img/Chain.png")));
        this.cellSyncSize.setToolTipText("Synchronize width and height");
        this.cellSyncSize.setFocusable(false);
        this.cellSyncSize.setMaximumSize(new Dimension(30, 30));
        this.cellSyncSize.setMinimumSize(new Dimension(0, 0));
        this.cellSyncSize.setPreferredSize(new Dimension(28, 28));
        this.rowsGridEnabled.setText("Show rows grid");
        this.rowsGridEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.rowsGridEnabledStateChanged(evt);
            }
        });
        this.jLabel1.setText("Color");
        this.jLabel5.setText("Size");
        this.rowsGridSize.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.rowsGridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.rowsGridSizeStateChanged(evt);
            }
        });
        this.columnsGridEnabled.setText("Show columns grid");
        this.columnsGridEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.columnsGridEnabledStateChanged(evt);
            }
        });
        this.jLabel2.setText("Color");
        this.jLabel6.setText("Size");
        this.columnsGridSize.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.columnsGridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HeatmapPropertiesCellsPanel.this.columnsGridSizeStateChanged(evt);
            }
        });
        this.jLabel7.setText("Scale");
        this.decoPanel.setAutoscrolls(true);
        this.decoPanel.setFocusable(false);
        this.decoPanel.setRequestFocusEnabled(false);
        this.decoPanel.setLayout(new BoxLayout(this.decoPanel, 2));
        this.saveScale.setIcon(new ImageIcon(this.getClass().getResource("/img/Save16.gif")));
        this.saveScale.setToolTipText("Save scale");
        this.saveScale.setFocusable(false);
        this.saveScale.setMaximumSize(new Dimension(30, 30));
        this.saveScale.setMinimumSize(new Dimension(0, 0));
        this.saveScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesCellsPanel.this.saveScaleActionPerformed(evt);
            }
        });
        this.loadScale.setIcon(new ImageIcon(this.getClass().getResource("/img/OpenAnalysis16.gif")));
        this.loadScale.setToolTipText("LoadScale");
        this.loadScale.setFocusable(false);
        this.loadScale.setMaximumSize(new Dimension(30, 30));
        this.loadScale.setMinimumSize(new Dimension(0, 0));
        this.loadScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeatmapPropertiesCellsPanel.this.loadScaleActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 214, Short.MAX_VALUE).addComponent(this.rowsGridEnabled, GroupLayout.Alignment.LEADING).addComponent(this.columnsGridEnabled, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rowsGridColor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsGridSize, -2, 54, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnsGridColor, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsGridSize, -2, 54, -2)))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.cellWidth, -2, 54, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cellHeight, -2, 54, -2))).addGap(18, 18, 18).addComponent(this.cellSyncSize, -2, -1, -2)).addComponent(this.cellDecorator, GroupLayout.Alignment.LEADING, 0, 214, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.loadScale, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveScale, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.decoPanel, -2, 202, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cellWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cellHeight, -2, -1, -2)).addGap(20, 20, 20).addComponent(this.rowsGridEnabled)).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.cellSyncSize, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.rowsGridSize, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent((Component)this.rowsGridColor, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.columnsGridEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.columnsGridSize, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabel2)).addComponent((Component)this.columnsGridColor, -2, -1, -2)).addGap(17, 17, 17).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cellDecorator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadScale, -2, -1, -2).addComponent(this.saveScale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoPanel, -1, 292, Short.MAX_VALUE).addContainerGap()));
    }

    private void cellWidthStateChanged(ChangeEvent evt) {
        int height;
        int width = (Integer)this.cellWidth.getValue();
        int dif = width - this.hm.getCellWidth();
        this.hm.setCellWidth(width);
        if (this.cellSyncSize.isSelected() && (height = this.hm.getCellHeight() + dif) > 0) {
            this.hm.setCellHeight(height);
        }
    }

    private void cellHeightStateChanged(ChangeEvent evt) {
        int width;
        int height = (Integer)this.cellHeight.getValue();
        int dif = height - this.hm.getCellHeight();
        this.hm.setCellHeight(height);
        if (this.cellSyncSize.isSelected() && (width = this.hm.getCellWidth() + dif) > 0) {
            this.hm.setCellWidth(width);
        }
    }

    private void rowsGridEnabledStateChanged(ChangeEvent evt) {
        this.hm.getRowDim().setGridEnabled(this.rowsGridEnabled.isSelected());
    }

    private void columnsGridEnabledStateChanged(ChangeEvent evt) {
        this.hm.getColumnDim().setGridEnabled(this.columnsGridEnabled.isSelected());
    }

    private void rowsGridSizeStateChanged(ChangeEvent evt) {
        int size = (Integer)this.rowsGridSize.getValue();
        this.hm.getRowDim().setGridSize(size);
    }

    private void columnsGridSizeStateChanged(ChangeEvent evt) {
        int size = (Integer)this.columnsGridSize.getValue();
        this.hm.getColumnDim().setGridSize(size);
    }

    private void saveScaleActionPerformed(ActionEvent evt) {
        DecoratorArchivePersistance archivePersistance = new DecoratorArchivePersistance();
        DecoratorArchive archive = archivePersistance.load();
        ElementDecorator d = this.hm.getActiveCellDecorator();
        SaveDecoratorDialog dialog = new SaveDecoratorDialog((Window)AppFrame.instance());
        dialog.setExistingScaleNames(archive.getDecorators().keySet());
        dialog.setName(d.getName());
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            return;
        }
        d.setName(dialog.getScaleName());
        archive.add(d);
        archivePersistance.save(archive);
    }

    private void loadScaleActionPerformed(ActionEvent evt) {
        DecoratorArchivePersistance archivePersistance = new DecoratorArchivePersistance();
        DecoratorArchive archive = archivePersistance.load();
        ElementDecorator d = this.hm.getActiveCellDecorator();
        ElementDecoratorDescriptor descriptor = ElementDecoratorFactory.getDescriptor(d.getClass());
        LoadDecoratorDialog<Object> dialog = new LoadDecoratorDialog<Object>((Window)AppFrame.instance(), d.getAdapter(), archive.getDecorators().values().toArray(), descriptor.getDecoratorClass());
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            return;
        }
        ElementDecorator loadedDecorator = dialog.getSelectedDecorator();
        loadedDecorator = this.setValueIndex(loadedDecorator, d.getAdapter(), this.hm.getMatrixView().getSelectedPropertyIndex());
        try {
            this.hm.replaceActiveDecorator(loadedDecorator);
        }
        catch (Exception ex) {
            Logger.getLogger(HeatmapPropertiesCellsPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cellDecoratorChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            ElementDecoratorDescriptor descriptor = ElementDecoratorFactory.getDescriptor(this.hm.getActiveCellDecorator().getClass());
            this.decoratorCache.put(descriptor, this.hm.getCellDecorators());
        } else if (evt.getStateChange() == 1) {
            ElementDecoratorDescriptor descriptor = (ElementDecoratorDescriptor)evt.getItem();
            ElementDecorator[] decorators = this.decoratorCache.get(descriptor);
            if (decorators == null) {
                IElementAdapter cellAdapter = this.hm.getActiveCellDecorator().getAdapter();
                int propNb = cellAdapter.getPropertyCount();
                decorators = new ElementDecorator[propNb];
                for (int i = 0; i < decorators.length; ++i) {
                    ElementDecorator decorator = ElementDecoratorFactory.create((ElementDecoratorDescriptor)descriptor, (IElementAdapter)cellAdapter);
                    this.setValueIndex(decorator, cellAdapter, i);
                    decorators[i] = decorator;
                }
            }
            this.hm.setCellDecorators(decorators);
            this.changeDecoratorPanel(descriptor);
        }
    }

    private ElementDecorator setValueIndex(ElementDecorator decorator, IElementAdapter cellAdapter, int currentValueIndex) {
        if (decorator instanceof ZScoreElementDecorator) {
            ZScoreElementDecorator zscoreDecorator = (ZScoreElementDecorator)decorator;
            int valueIndex = cellAdapter.getPropertyIndex("z-score");
            int correctedValueIndex = cellAdapter.getPropertyIndex("corrected-two-tail-p-value");
            zscoreDecorator.setValueIndex(valueIndex != -1 ? valueIndex : currentValueIndex);
            zscoreDecorator.setCorrectedValueIndex(correctedValueIndex != -1 ? correctedValueIndex : currentValueIndex);
            decorator = zscoreDecorator;
        } else if (decorator instanceof PValueElementDecorator) {
            int valueIndex = cellAdapter.getPropertyIndex("right-p-value");
            decorator.setValueIndex(valueIndex != -1 ? valueIndex : currentValueIndex);
        } else {
            decorator.setValueIndex(currentValueIndex);
        }
        return decorator;
    }

    private void changeDecoratorPanel(ElementDecoratorDescriptor descriptor) {
        JPanel confPanel = new JPanel();
        confPanel.setLayout(new BorderLayout());
        Class decoratorClass = descriptor.getDecoratorClass();
        JComponent c = ElementDecoratorPanelFactory.create(decoratorClass, this.hm);
        confPanel.add((Component)c, "Center");
        this.decoPanel.removeAll();
        this.decoPanel.setLayout(new BorderLayout());
        this.decoPanel.add((Component)c, "Center");
    }
}

