/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel.details;

import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.colorscale.impl.ZScoreColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.textpatt.TextPattern;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.combination.CombinationResult;
import org.gitools.analysis.correlation.CorrelationResult;
import org.gitools.analysis.overlapping.OverlappingResult;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.idtype.IdType;
import org.gitools.idtype.IdTypeManager;
import org.gitools.idtype.UrlLink;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.AnnotationResolver;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.stats.test.results.BinomialResult;
import org.gitools.stats.test.results.FisherResult;
import org.gitools.stats.test.results.ZScoreResult;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.panel.TemplatePanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.view.entity.EntityController;

public class HeatmapDetailsController
implements EntityController {
    private static final String defaultTemplateName = "/vm/details/noselection.vm";
    private static final String headerTemplateName = "/vm/details/header.vm";
    private static final String heatmapTemplateName = "/vm/details/heatmap.vm";
    private TemplatePanel templatePanel;

    protected TemplatePanel getTemplatePanel() {
        if (this.templatePanel == null) {
            Properties props = new Properties();
            this.templatePanel = new TemplatePanel(props){

                protected void performUrlAction(String name, Map<String, String> params) {
                    HeatmapDetailsController.this.performUrlAction(name, params);
                }
            };
        }
        return this.templatePanel;
    }

    private void performUrlAction(String name, Map<String, String> params) {
        if ("action:igv".equals(name)) {
            IgvCommand igv = new IgvCommand(params);
            JobThread.execute((Window)AppFrame.instance(), (JobRunnable)igv);
        }
    }

    @Override
    public JComponent getComponent(Object ctx) {
        String url;
        TextPattern pat;
        List tlinks;
        String idTypeKey;
        IdType idType;
        AnnotationMatrix annMatrix;
        String label;
        TemplatePanel panel = this.getTemplatePanel();
        Heatmap heatmap = (Heatmap)ctx;
        IMatrixView matrixView = heatmap.getMatrixView();
        int row = matrixView.getLeadSelectionRow();
        int rowCount = matrixView.getRowCount();
        int column = matrixView.getLeadSelectionColumn();
        int columnCount = matrixView.getColumnCount();
        VelocityContext context = new VelocityContext();
        context.put("fmt", (Object)new GenericFormatter());
        String templateName = heatmapTemplateName;
        context.put("rowIndex", (Object)(row + 1));
        context.put("columnIndex", (Object)(column + 1));
        context.put("title", (Object)heatmap.getTitle());
        context.put("notes", (Object)heatmap.getDescription());
        context.put("attributes", (Object)heatmap.getAttributes());
        context.put("numColumns", (Object)matrixView.getColumnCount());
        context.put("numRows", (Object)matrixView.getRowCount());
        String igvColumnLabel = null;
        String igvRowLabel = null;
        if (column >= 0 && column < columnCount && row >= 0 && row < rowCount) {
            igvRowLabel = heatmap.getMatrixView().getRowLabel(row);
            igvColumnLabel = heatmap.getMatrixView().getColumnLabel(column);
            String columnId = matrixView.getColumnLabel(column);
            String columnLabel = heatmap.getColumnLabel(column);
            String rowId = matrixView.getRowLabel(row);
            String rowLabel = heatmap.getRowLabel(row);
            IElementAdapter cellAdapter = matrixView.getCellAdapter();
            Object cellElement = matrixView.getCell(row, column);
            templateName = this.getTemplateNameFromObject(cellElement);
            if (templateName != null) {
                context.put("zscoreScale", (Object)new ZScoreColorScale());
                context.put("pvalueScale", (Object)new PValueColorScale());
                context.put("columnId", (Object)columnId);
                context.put("columnLabel", (Object)columnLabel);
                context.put("columnElement", (Object)columnLabel);
                context.put("rowId", (Object)rowId);
                context.put("rowLabel", (Object)rowLabel);
                context.put("rowElement", (Object)rowLabel);
                context.put("cellAdapter", (Object)cellAdapter);
                context.put("cellElement", cellElement);
                List properties = cellAdapter.getProperties();
                HashMap<String, Object> cellMap = new HashMap<String, Object>();
                HashMap<String, IElementAttribute> attrMap = new HashMap<String, IElementAttribute>();
                for (int index = 0; index < properties.size(); ++index) {
                    IElementAttribute prop = (IElementAttribute)properties.get(index);
                    cellMap.put(prop.getId(), cellAdapter.getValue(cellElement, index));
                    attrMap.put(prop.getId(), prop);
                }
                context.put("cell", cellMap);
                context.put("attr", attrMap);
            }
        }
        String name = "";
        List annotations = new ArrayList(0);
        LinkedHashMap<String, String> links = new LinkedHashMap<String, String>();
        if (Settings.getDefault().isShowIGVLink() && (row >= 0 || column >= 0)) {
            links.put("Locate in genomic viewer (IGV)", "action:igv?" + (row >= 0 ? "row=" + heatmap.getRowLabel(row) + "&" : "") + (column >= 0 ? "column=" + heatmap.getColumnLabel(column) : ""));
        }
        if (row >= 0 && row < rowCount) {
            HeatmapDim rowDim = heatmap.getRowDim();
            name = heatmap.getRowLabel(row);
            label = heatmap.getMatrixView().getRowLabel(row);
            annMatrix = rowDim.getAnnotations();
            if (annMatrix != null) {
                annotations = annMatrix.getAnnotations(label);
            }
            if ((idType = rowDim.getIdType()) != null) {
                idTypeKey = idType.getKey();
                tlinks = IdTypeManager.getDefault().getLinks(idTypeKey);
                AnnotationResolver resolver = new AnnotationResolver(annMatrix, label);
                for (UrlLink link : tlinks) {
                    pat = link.getPattern();
                    url = pat.generate((TextPattern.VariableValueResolver)resolver);
                    links.put(link.getName() + " (" + label + ")", url);
                }
            }
        }
        if (column >= 0 && column < columnCount) {
            HeatmapDim colDim = heatmap.getColumnDim();
            name = heatmap.getColumnLabel(column);
            label = heatmap.getMatrixView().getColumnLabel(column);
            annMatrix = colDim.getAnnotations();
            if (annMatrix != null) {
                annotations = annMatrix.getAnnotations(label);
            }
            if ((idType = colDim.getIdType()) != null) {
                idTypeKey = idType.getKey();
                tlinks = IdTypeManager.getDefault().getLinks(idTypeKey);
                AnnotationResolver resolver = new AnnotationResolver(annMatrix, label);
                for (UrlLink link : tlinks) {
                    pat = link.getPattern();
                    url = pat.generate((TextPattern.VariableValueResolver)resolver);
                    links.put(link.getName() + " (" + label + ")", url);
                }
            }
        }
        context.put("name", (Object)name);
        context.put("annotations", annotations);
        context.put("links", links);
        try {
            panel.setTemplateFromResource(templateName);
            panel.setContext(context);
            panel.render();
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.close();
            return new JLabel(sw.toString());
        }
        return panel;
    }

    private String getTemplateNameFromObject(Object object) {
        String templateName = "generic.vm";
        if (object != null) {
            if (object instanceof BinomialResult) {
                templateName = "binomial.vm";
            } else if (object instanceof FisherResult) {
                templateName = "fisher.vm";
            } else if (object instanceof ZScoreResult) {
                templateName = "zscore.vm";
            } else if (object instanceof CorrelationResult) {
                templateName = "correlation.vm";
            } else if (object instanceof CombinationResult) {
                templateName = "combination.vm";
            } else if (object instanceof OverlappingResult) {
                templateName = "overlapping.vm";
            }
        }
        return "/vm/details/" + templateName;
    }

    private class IgvCommand
    implements JobRunnable {
        private Map<String, String> params;

        private IgvCommand(Map<String, String> params) {
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Socket socket = null;
            try {
                String cmd;
                monitor.title("Connecting with Integrative Genomics Viewer");
                String[] igvUrl = Settings.getDefault().getIgvUrl().replace("http://", "").split(":");
                socket = new Socket(igvUrl[0], (int)Integer.valueOf(igvUrl[1]));
                System.out.println();
                socket.setSoTimeout(Settings.getDefault().getIgvTimeout());
                PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                if (this.params.containsKey("column")) {
                    monitor.info("Locating " + this.params.get("column"));
                    cmd = "goto " + this.params.get("column");
                    out.println(cmd);
                    String string = in.readLine();
                }
                if (this.params.containsKey("row")) {
                    monitor.info("Locating " + this.params.get("row"));
                    cmd = "goto " + this.params.get("row");
                    out.println(cmd);
                    String response = in.readLine();
                }
            }
            catch (ConnectException e) {
                monitor.end();
                this.showMessage("Unable to connect with Integrative Genomics Viewer (IGV). \n It must be running on '" + Settings.getDefault().getIgvUrl() + "'. " + "\n Install or launch it from 'http://www.broadinstitute.org/igv'.");
            }
            catch (SocketTimeoutException e) {
                monitor.end();
                this.showMessage("Timeout connecting with Integrative Genomics Viewer (IGV) on '" + Settings.getDefault().getIgvUrl() + "'. ");
            }
            catch (IOException e) {
                monitor.end();
                this.showMessage("Unknown problem 'e.getMessage()' connecting with Integrative Genomics Viewer (IGV). Check GiTools help.");
            }
            finally {
                monitor.end();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void showMessage(String msg) {
            AppFrame frame = AppFrame.instance();
            JOptionPane.showMessageDialog(frame, msg);
        }
    }
}

