/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.heatmap.panel.HeatmapBodyMouseController;
import org.gitools.ui.heatmap.panel.HeatmapBodyPanel;
import org.gitools.ui.heatmap.panel.HeatmapHeaderMouseController;
import org.gitools.ui.heatmap.panel.HeatmapHeaderPanel;
import org.gitools.ui.heatmap.panel.HeatmapKeyboardController;
import org.gitools.ui.heatmap.panel.HeatmapLayout;
import org.gitools.ui.heatmap.panel.HeatmapMouseListener;

public class HeatmapPanel
extends JPanel {
    private static final long serialVersionUID = 5817479437770943868L;
    private Heatmap heatmap;
    private final PropertyChangeListener heatmapListener;
    private HeatmapBodyPanel bodyPanel;
    private HeatmapHeaderPanel columnHeaderPanel;
    private HeatmapHeaderPanel rowHeaderPanel;
    private JViewport bodyVP;
    private JViewport colVP;
    private JViewport rowVP;
    private JScrollBar colSB;
    private JScrollBar rowSB;
    private List<HeatmapMouseListener> mouseListeners = new ArrayList<HeatmapMouseListener>();

    public HeatmapPanel(Heatmap heatmap) {
        this.heatmap = heatmap;
        this.heatmapListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapPanel.this.heatmapPropertyChanged(evt);
            }
        };
        this.createComponents();
        this.heatmapChanged(null);
        this.setFocusable(true);
    }

    public Heatmap getHeatmap() {
        return this.heatmap;
    }

    public void setHeatmap(Heatmap heatmap) {
        Heatmap old = this.heatmap;
        this.heatmap = heatmap;
        this.bodyPanel.setHeatmap(heatmap);
        this.columnHeaderPanel.setHeatmap(heatmap);
        this.rowHeaderPanel.setHeatmap(heatmap);
        this.heatmapChanged(old);
    }

    private void createComponents() {
        this.bodyPanel = new HeatmapBodyPanel(this.heatmap);
        this.columnHeaderPanel = new HeatmapHeaderPanel(this.heatmap, true);
        this.rowHeaderPanel = new HeatmapHeaderPanel(this.heatmap, false);
        this.bodyVP = new JViewport();
        this.bodyVP.setView(this.bodyPanel);
        HeatmapMouseListener mouseListenerProxy = new HeatmapMouseListener(){

            @Override
            public void mouseMoved(int row, int col, MouseEvent e) {
                for (HeatmapMouseListener l : HeatmapPanel.this.mouseListeners) {
                    l.mouseMoved(row, col, e);
                }
            }

            @Override
            public void mouseClicked(int row, int col, MouseEvent e) {
                for (HeatmapMouseListener l : HeatmapPanel.this.mouseListeners) {
                    l.mouseClicked(row, col, e);
                }
            }
        };
        HeatmapBodyMouseController bodyController = new HeatmapBodyMouseController(this);
        bodyController.addHeatmapMouseListener(mouseListenerProxy);
        this.colVP = new JViewport();
        this.colVP.setView(this.columnHeaderPanel);
        HeatmapHeaderMouseController colMouseCtrl = new HeatmapHeaderMouseController(this, true);
        colMouseCtrl.addHeatmapMouseListener(mouseListenerProxy);
        this.rowVP = new JViewport();
        this.rowVP.setView(this.rowHeaderPanel);
        HeatmapHeaderMouseController rowMouseCtrl = new HeatmapHeaderMouseController(this, false);
        rowMouseCtrl.addHeatmapMouseListener(mouseListenerProxy);
        this.colSB = new JScrollBar(0);
        this.colSB.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                HeatmapPanel.this.updateViewPorts();
            }
        });
        this.rowSB = new JScrollBar(1);
        this.rowSB.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                HeatmapPanel.this.updateViewPorts();
            }
        });
        this.setLayout(new HeatmapLayout());
        this.add(this.colVP);
        this.add(this.rowVP);
        this.add(this.bodyVP);
        this.add(this.colSB);
        this.add(this.rowSB);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                HeatmapPanel.this.updateScrolls();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        new HeatmapKeyboardController(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HeatmapPanel.this.heatmap.getMatrixView().setLeadSelection(-1, -1);
                HeatmapPanel.this.heatmap.getMatrixView().clearSelection();
            }
        });
    }

    private void updateScrolls() {
        Dimension totalSize = this.bodyVP.getViewSize();
        Dimension visibleSize = this.bodyVP.getSize();
        int scrollWidth = totalSize.width - visibleSize.width;
        int scrollHeight = totalSize.height - visibleSize.height;
        IMatrixView mv = this.heatmap.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        Point leadPoint = this.bodyPanel.getDrawer().getPoint(new HeatmapPosition(row, col));
        HeatmapDim rowDim = this.heatmap.getRowDim();
        HeatmapDim colDim = this.heatmap.getColumnDim();
        int leadPointXEnd = leadPoint.x + this.heatmap.getCellWidth() + (colDim.isGridEnabled() ? colDim.getGridSize() : 0);
        int leadPointYEnd = leadPoint.y + this.heatmap.getCellHeight() + (rowDim.isGridEnabled() ? rowDim.getGridSize() : 0);
        this.colSB.setValueIsAdjusting(true);
        this.colSB.setMinimum(0);
        this.colSB.setMaximum(totalSize.width - 1);
        if (this.colSB.getValue() > scrollWidth) {
            this.colSB.setValue(scrollWidth);
        }
        if (leadPoint.x < this.colSB.getValue()) {
            this.colSB.setValue(leadPoint.x);
        } else if (leadPointXEnd > this.colSB.getValue() + visibleSize.width) {
            this.colSB.setValue(leadPointXEnd - visibleSize.width);
        }
        this.colSB.setVisibleAmount(visibleSize.width);
        this.colSB.setValueIsAdjusting(false);
        this.rowSB.setValueIsAdjusting(true);
        this.rowSB.setMinimum(0);
        this.rowSB.setMaximum(totalSize.height - 1);
        if (this.rowSB.getValue() > scrollHeight) {
            this.rowSB.setValue(scrollHeight);
        }
        if (leadPoint.y < this.rowSB.getValue()) {
            this.rowSB.setValue(leadPoint.y);
        } else if (leadPointYEnd > this.rowSB.getValue() + visibleSize.height) {
            this.rowSB.setValue(leadPointYEnd - visibleSize.height);
        }
        this.rowSB.setVisibleAmount(visibleSize.height);
        this.rowSB.setValueIsAdjusting(false);
    }

    private void updateViewPorts() {
        int rowValue;
        Dimension totalSize = this.bodyVP.getViewSize();
        Dimension visibleSize = this.bodyVP.getSize();
        int colValue = this.colSB.getValue();
        if (colValue + visibleSize.width > totalSize.width) {
            colValue = totalSize.width - visibleSize.width;
        }
        if ((rowValue = this.rowSB.getValue()) + visibleSize.height > totalSize.height) {
            rowValue = totalSize.height - visibleSize.height;
        }
        this.colVP.setViewPosition(new Point(colValue, 0));
        this.rowVP.setViewPosition(new Point(0, rowValue));
        this.bodyVP.setViewPosition(new Point(colValue, rowValue));
    }

    public JViewport getBodyViewPort() {
        return this.bodyVP;
    }

    public JViewport getColumnViewPort() {
        return this.colVP;
    }

    public JViewport getRowViewPort() {
        return this.rowVP;
    }

    public HeatmapBodyPanel getBodyPanel() {
        return this.bodyPanel;
    }

    public HeatmapHeaderPanel getColumnPanel() {
        return this.columnHeaderPanel;
    }

    public HeatmapHeaderPanel getRowPanel() {
        return this.rowHeaderPanel;
    }

    public HeatmapPosition getScrollPosition() {
        Point pos = new Point(this.colSB.getValue(), this.rowSB.getValue());
        return this.bodyPanel.getDrawer().getPosition(pos);
    }

    public Point getScrollValue() {
        return new Point(this.colSB.getValue(), this.rowSB.getValue());
    }

    public void setScrollColumnPosition(int index) {
        Point pos = this.bodyPanel.getDrawer().getPoint(new HeatmapPosition(0, index));
        this.colSB.setValue(pos.x);
    }

    public void setScrollColumnValue(int value) {
        this.colSB.setValue(value);
    }

    public void setScrollRowPosition(int index) {
        Point pos = this.bodyPanel.getDrawer().getPoint(new HeatmapPosition(index, 0));
        this.rowSB.setValue(pos.y);
    }

    public void setScrollRowValue(int value) {
        this.rowSB.setValue(value);
    }

    private void heatmapChanged(Heatmap old) {
        if (old != null) {
            old.removePropertyChangeListener(this.heatmapListener);
        }
        this.heatmap.addPropertyChangeListener(this.heatmapListener);
    }

    private void heatmapPropertyChanged(PropertyChangeEvent evt) {
        boolean updateAll;
        String pname = evt.getPropertyName();
        Object src = evt.getSource();
        boolean bl = updateAll = src.equals(this.heatmap) && "cellSize".equals(pname) || src instanceof HeatmapDim && ("gridProperty".equals(pname) || "headers".equals(pname) || "headerSize".equals(pname)) || src instanceof HeatmapHeader && ("size".equals(pname) || "visible".equals(pname)) || src.equals(this.heatmap.getMatrixView()) && ("visibleColsChanged".equals(pname) || "visibleRowsChanged".equals(pname) || "selectionLead".equals(pname));
        if (updateAll) {
            this.bodyPanel.updateSize();
            this.rowHeaderPanel.updateSize();
            this.columnHeaderPanel.updateSize();
            this.updateScrolls();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension sz = this.getSize();
        Rectangle r = new Rectangle(new Point(0, 0), sz);
        g.setColor(Color.WHITE);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    public void addHeatmapMouseListener(HeatmapMouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public void removeHeatmapMouseListener(HeatmapMouseListener listener) {
        this.mouseListeners.remove(listener);
    }
}

