/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.heatmap.panel.HeatmapPanel;

public class HeatmapKeyboardController
extends KeyAdapter {
    private HeatmapPanel panel;
    private Heatmap hm;
    private int selStart;
    private int selEnd;
    private int selLast;

    HeatmapKeyboardController(HeatmapPanel panel) {
        this.panel = panel;
        this.hm = panel.getHeatmap();
        this.selLast = -1;
        this.selEnd = -1;
        this.selStart = -1;
        panel.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean altDown;
        IMatrixView mv = this.hm.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        int key = e.getKeyCode();
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean ctrlDown = (modifiers & 2) != 0;
        boolean bl = altDown = (modifiers & 8) != 0;
        if (key == 40 || key == 38 || key == 37 || key == 39 || key == 36 || key == 35 || key == 33 || key == 34) {
            if ((!shiftDown && !ctrlDown || shiftDown && !ctrlDown || !shiftDown && ctrlDown) && !altDown) {
                this.changeLead(e);
            } else if (shiftDown && ctrlDown && !altDown) {
                this.moveLead(e);
            } else if (!shiftDown && !ctrlDown && altDown) {
                this.moveSelection(e);
            }
            if (ctrlDown) {
                e.consume();
            }
        } else {
            switch (key) {
                case 127: {
                    this.hideLead(e);
                    break;
                }
                case 32: {
                    this.selectLead(e);
                }
            }
        }
    }

    private void changeLead(KeyEvent e) {
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean ctrlDown = (modifiers & 2) != 0;
        IMatrixView mv = this.hm.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        int prevRow = row;
        int prevCol = col;
        int rowPageSize = 10;
        int colPageSize = 10;
        switch (e.getKeyCode()) {
            case 40: {
                if (row >= mv.getRowCount() - 1) break;
                ++row;
                break;
            }
            case 38: {
                if (row > 0) {
                    --row;
                    break;
                }
                if (col == -1) break;
                row = -1;
                break;
            }
            case 39: {
                if (col >= 0 && col < mv.getColumnCount() - 1) {
                    ++col;
                    break;
                }
                if (row == -1) break;
                col = -1;
                break;
            }
            case 37: {
                if (col > 0) {
                    --col;
                    break;
                }
                if (col != -1) break;
                col = mv.getColumnCount() - 1;
                break;
            }
            case 33: {
                if (row != -1) {
                    if ((row -= 10) >= 0) break;
                    row = 0;
                    break;
                }
                if (row != -1 || col == -1 || (col -= 10) >= 0) break;
                col = 0;
                break;
            }
            case 34: {
                if (row != -1) {
                    if ((row += 10) < mv.getRowCount()) break;
                    row = mv.getRowCount() - 1;
                    break;
                }
                if (row != -1 || col == -1 || (col += 10) < mv.getColumnCount()) break;
                col = mv.getColumnCount() - 1;
                break;
            }
            case 36: {
                if (row != -1) {
                    row = 0;
                    break;
                }
                if (row != -1 || col == -1) break;
                col = 0;
                break;
            }
            case 35: {
                if (row != -1) {
                    row = mv.getRowCount() - 1;
                    break;
                }
                if (row != -1 || col == -1) break;
                col = mv.getColumnCount() - 1;
            }
        }
        boolean clearSelection = true;
        boolean onRow = row != -1 && col == -1;
        boolean onBody = row != -1 && col != -1;
        int[] sel = null;
        if (onBody || !shiftDown && !ctrlDown) {
            this.selEnd = -1;
            this.selStart = -1;
        } else if (!onBody && shiftDown && !ctrlDown) {
            int n = this.selEnd = onRow ? row : col;
            if (this.selStart == -1) {
                this.selStart = this.selLast != -1 ? this.selLast : this.selEnd;
            }
            int start = this.selStart <= this.selEnd ? this.selStart : this.selEnd;
            int end = this.selStart <= this.selEnd ? this.selEnd : this.selStart;
            int size = end - start + 1;
            sel = new int[size];
            for (int i = start; i <= end; ++i) {
                sel[i - start] = i;
            }
            clearSelection = false;
        } else if (!shiftDown && ctrlDown) {
            clearSelection = false;
        }
        this.selLast = !onBody ? (onRow ? row : col) : -1;
        mv.setLeadSelection(row, col);
        if (clearSelection) {
            mv.clearSelection();
        } else if (!onBody && sel != null) {
            if (onRow) {
                mv.setSelectedRows(sel);
            } else {
                mv.setSelectedColumns(sel);
            }
        }
    }

    private void hideLead(KeyEvent e) {
        IMatrixView mv = this.hm.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        if (row != -1) {
            mv.hideRows(mv.getSelectedRows());
        }
        if (col != -1) {
            mv.hideColumns(mv.getSelectedColumns());
        }
    }

    private void moveLead(KeyEvent e) {
        IMatrixView mv = this.hm.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        switch (e.getKeyCode()) {
            case 40: {
                if (row < 0 || row >= mv.getRowCount() - 1) break;
                mv.moveRowsDown(new int[]{row});
                break;
            }
            case 38: {
                if (row <= 0 || row >= mv.getRowCount()) break;
                mv.moveRowsUp(new int[]{row});
                break;
            }
            case 39: {
                if (col < 0 || col >= mv.getColumnCount() - 1) break;
                mv.moveColumnsRight(new int[]{col});
                break;
            }
            case 37: {
                if (col <= 0 || col >= mv.getColumnCount()) break;
                mv.moveColumnsLeft(new int[]{col});
            }
        }
    }

    private void moveSelection(KeyEvent e) {
        int[] sel;
        IMatrixView mv = this.hm.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        boolean horizontal = row == -1 && col >= 0;
        int[] nArray = sel = horizontal ? mv.getSelectedColumns() : mv.getSelectedRows();
        if (sel.length == 0 && (horizontal && col != -1 || !horizontal && row != -1)) {
            int[] nArray2;
            if (horizontal) {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = col;
            } else {
                int[] nArray4 = new int[1];
                nArray2 = nArray4;
                nArray4[0] = row;
            }
            sel = nArray2;
        }
        switch (e.getKeyCode()) {
            case 40: {
                if (row < 0 || row >= mv.getRowCount() - 1) break;
                mv.moveRowsDown(sel);
                break;
            }
            case 38: {
                if (row <= 0 || row >= mv.getRowCount()) break;
                mv.moveRowsUp(sel);
                break;
            }
            case 39: {
                if (col < 0 || col >= mv.getColumnCount() - 1) break;
                mv.moveColumnsRight(sel);
                break;
            }
            case 37: {
                if (col <= 0 || col >= mv.getColumnCount()) break;
                mv.moveColumnsLeft(sel);
            }
        }
    }

    private void selectLead(KeyEvent e) {
        int[] sel;
        boolean horizontal;
        IMatrixView mv;
        block10: {
            int[] prevSel;
            int index;
            int col;
            int row;
            block8: {
                block9: {
                    mv = this.hm.getMatrixView();
                    row = mv.getLeadSelectionRow();
                    col = mv.getLeadSelectionColumn();
                    if (row != -1 && col != -1) {
                        return;
                    }
                    int modifiers = e.getModifiers();
                    boolean shiftDown = (modifiers & 1) != 0;
                    boolean ctrlDown = (modifiers & 2) != 0;
                    horizontal = row == -1 && col >= 0;
                    index = horizontal ? col : row;
                    sel = null;
                    if (ctrlDown) break block8;
                    if (row < 0 || col != -1) break block9;
                    sel = new int[]{row};
                    break block10;
                }
                if (row != -1 || col < 0) break block10;
                sel = new int[]{col};
                break block10;
            }
            boolean selected = horizontal ? mv.isColumnSelected(col) : mv.isRowSelected(row);
            int[] nArray = prevSel = horizontal ? mv.getSelectedColumns() : mv.getSelectedRows();
            if (!selected) {
                sel = new int[prevSel.length + 1];
                System.arraycopy(prevSel, 0, sel, 0, prevSel.length);
                sel[sel.length - 1] = index;
                Arrays.sort(sel);
            } else {
                sel = new int[prevSel.length - 1];
                int j = 0;
                for (int i = 0; i < prevSel.length; ++i) {
                    if (prevSel[i] == index) continue;
                    sel[j++] = prevSel[i];
                }
            }
        }
        if (horizontal) {
            if (mv.getSelectedRows().length != 0) {
                mv.setSelectedRows(new int[0]);
            }
            mv.setSelectedColumns(sel);
        } else {
            if (mv.getSelectedColumns().length != 0) {
                mv.setSelectedColumns(new int[0]);
            }
            mv.setSelectedRows(sel);
        }
    }
}

