/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JViewport;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.heatmap.panel.HeatmapHeaderPanel;
import org.gitools.ui.heatmap.panel.HeatmapMouseListener;
import org.gitools.ui.heatmap.panel.HeatmapPanel;

public class HeatmapHeaderMouseController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final Heatmap heatmap;
    private final JViewport viewPort;
    private final HeatmapHeaderPanel headerPanel;
    private final HeatmapPanel panel;
    private final boolean horizontal;
    private Mode mode;
    private Point point;
    private HeatmapPosition position;
    private int selStart;
    private int selEnd;
    private int selLast;
    private Point startPoint;
    private Point startScrollValue;
    private List<HeatmapMouseListener> listeners = new ArrayList<HeatmapMouseListener>(1);

    public HeatmapHeaderMouseController(HeatmapPanel panel, boolean horizontal) {
        this.heatmap = panel.getHeatmap();
        this.viewPort = horizontal ? panel.getColumnViewPort() : panel.getRowViewPort();
        this.headerPanel = horizontal ? panel.getColumnPanel() : panel.getRowPanel();
        this.panel = panel;
        this.horizontal = horizontal;
        this.viewPort.addMouseListener(this);
        this.viewPort.addMouseMotionListener(this);
        this.viewPort.addMouseWheelListener(this);
        this.mode = Mode.none;
    }

    public void addHeatmapMouseListener(HeatmapMouseListener listener) {
        this.listeners.add(listener);
    }

    public void removeHeatmapMouseListener(HeatmapMouseListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int limit;
        this.panel.requestFocusInWindow();
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.position = this.headerPanel.getDrawer().getPosition(this.point);
        int index = this.horizontal ? this.position.column : this.position.row;
        int n = limit = this.horizontal ? this.heatmap.getMatrixView().getColumnCount() : this.heatmap.getMatrixView().getRowCount();
        if (index < 0 || index >= limit) {
            return;
        }
        int row = this.horizontal ? -1 : index;
        int col = this.horizontal ? index : -1;
        for (HeatmapMouseListener l : this.listeners) {
            l.mouseClicked(row, col, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean ctrlDown = (modifiers & 2) != 0;
        this.mode = shiftDown && ctrlDown ? Mode.moving : Mode.selecting;
        switch (this.mode) {
            case selecting: {
                this.updateSelection(e, false);
                break;
            }
            case moving: {
                this.updateScroll(e, false);
            }
        }
        this.panel.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mode = Mode.none;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        switch (this.mode) {
            case selecting: {
                this.updateSelection(e, true);
                break;
            }
            case moving: {
                this.updateScroll(e, true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int limit;
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.position = this.headerPanel.getDrawer().getPosition(this.point);
        int index = this.horizontal ? this.position.column : this.position.row;
        int n = limit = this.horizontal ? this.heatmap.getMatrixView().getColumnCount() : this.heatmap.getMatrixView().getRowCount();
        if (index < 0 || index >= limit) {
            return;
        }
        int row = this.horizontal ? -1 : index;
        int col = this.horizontal ? index : -1;
        for (HeatmapMouseListener l : this.listeners) {
            l.mouseMoved(row, col, e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean ctrlDown;
        int rotation = e.getWheelRotation();
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean bl = ctrlDown = (modifiers & 2) != 0;
        if (!shiftDown && !ctrlDown) {
            HeatmapPosition pos = this.panel.getScrollPosition();
            if (this.horizontal) {
                this.panel.setScrollColumnPosition(pos.column + rotation);
            } else {
                this.panel.setScrollRowPosition(pos.row + rotation);
            }
        } else {
            int height;
            int width = this.heatmap.getCellWidth() + rotation * -1;
            if (width < 1) {
                width = 1;
            }
            if ((height = this.heatmap.getCellHeight() + rotation * -1) < 1) {
                height = 1;
            }
            this.heatmap.setCellWidth(width);
            this.heatmap.setCellHeight(height);
        }
    }

    private void updateSelection(MouseEvent e, boolean dragging) {
        int limit;
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.position = this.headerPanel.getDrawer().getPosition(this.point);
        int index = this.horizontal ? this.position.column : this.position.row;
        int n = limit = this.horizontal ? this.heatmap.getMatrixView().getColumnCount() : this.heatmap.getMatrixView().getRowCount();
        if (index < 0 || index >= limit) {
            return;
        }
        boolean indexChanged = this.selLast != index;
        this.selLast = index;
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean ctrlDown = (modifiers & 2) != 0;
        IMatrixView mv = this.heatmap.getMatrixView();
        int[] sel = null;
        if (!(dragging || shiftDown || ctrlDown)) {
            this.selStart = this.selEnd = index;
            sel = new int[]{index};
        } else if (ctrlDown) {
            int[] prevSel;
            boolean selected = this.horizontal ? mv.isColumnSelected(index) : mv.isRowSelected(index);
            int[] nArray = prevSel = this.horizontal ? mv.getSelectedColumns() : mv.getSelectedRows();
            if (dragging && !indexChanged) {
                sel = prevSel;
            } else if (!selected) {
                sel = new int[prevSel.length + 1];
                System.arraycopy(prevSel, 0, sel, 0, prevSel.length);
                sel[sel.length - 1] = index;
                Arrays.sort(sel);
            } else {
                sel = new int[prevSel.length - 1];
                int j = 0;
                for (int i = 0; i < prevSel.length; ++i) {
                    if (prevSel[i] == index) continue;
                    sel[j++] = prevSel[i];
                }
            }
        } else if (dragging || shiftDown) {
            this.selEnd = index;
            int start = this.selStart <= this.selEnd ? this.selStart : this.selEnd;
            int end = this.selStart <= this.selEnd ? this.selEnd : this.selStart;
            int size = end - start + 1;
            sel = new int[size];
            for (int i = start; i <= end; ++i) {
                sel[i - start] = i;
            }
        } else {
            sel = new int[]{};
        }
        if (this.horizontal) {
            if (mv.getSelectedRows().length != 0) {
                mv.setSelectedRows(new int[0]);
            }
            mv.setSelectedColumns(sel);
        } else {
            if (mv.getSelectedColumns().length != 0) {
                mv.setSelectedColumns(new int[0]);
            }
            mv.setSelectedRows(sel);
        }
        if (this.horizontal) {
            mv.setLeadSelection(-1, index);
        } else {
            mv.setLeadSelection(index, -1);
        }
    }

    private void updateScroll(MouseEvent e, boolean dragging) {
        this.point = e.getPoint();
        if (!dragging) {
            this.startPoint = this.point;
            this.startScrollValue = this.panel.getScrollValue();
        } else {
            int widthOffset = this.point.x - this.startPoint.x;
            int heightOffset = this.point.y - this.startPoint.y;
            if (this.horizontal) {
                this.panel.setScrollColumnValue(this.startScrollValue.x - widthOffset);
            } else {
                this.panel.setScrollRowValue(this.startScrollValue.y - heightOffset);
            }
        }
    }

    private static enum Mode {
        none,
        selecting,
        moving;

    }
}

