/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.heatmap.panel.HeatmapBodyPanel;
import org.gitools.ui.heatmap.panel.HeatmapMouseListener;
import org.gitools.ui.heatmap.panel.HeatmapPanel;

public class HeatmapBodyMouseController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final Heatmap heatmap;
    private final JViewport viewPort;
    private final HeatmapPanel panel;
    private final HeatmapBodyPanel bodyPanel;
    private Mode mode;
    private Point point;
    private HeatmapPosition coord;
    private Point startPoint;
    private Point startScrollValue;
    private List<HeatmapMouseListener> listeners = new ArrayList<HeatmapMouseListener>(1);

    public HeatmapBodyMouseController(HeatmapPanel panel) {
        this.heatmap = panel.getHeatmap();
        this.viewPort = panel.getBodyViewPort();
        this.bodyPanel = panel.getBodyPanel();
        this.panel = panel;
        this.viewPort.addMouseListener(this);
        this.viewPort.addMouseMotionListener(this);
        this.viewPort.addMouseWheelListener(this);
        this.mode = Mode.none;
    }

    public void addHeatmapMouseListener(HeatmapMouseListener listener) {
        this.listeners.add(listener);
    }

    public void removeHeatmapMouseListener(HeatmapMouseListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.panel.requestFocusInWindow();
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.coord = this.bodyPanel.getDrawer().getPosition(this.point);
        for (HeatmapMouseListener l : this.listeners) {
            l.mouseClicked(this.coord.row, this.coord.column, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean ctrlDown = (modifiers & 2) != 0;
        this.mode = shiftDown || ctrlDown ? Mode.moving : Mode.selecting;
        switch (this.mode) {
            case selecting: {
                this.updateSelection(e);
                break;
            }
            case moving: {
                this.updateScroll(e, false);
            }
        }
        this.panel.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mode = Mode.none;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        switch (this.mode) {
            case selecting: {
                this.updateSelection(e);
                break;
            }
            case moving: {
                this.updateScroll(e, true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.coord = this.bodyPanel.getDrawer().getPosition(this.point);
        for (HeatmapMouseListener l : this.listeners) {
            l.mouseMoved(this.coord.row, this.coord.column, e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean ctrlDown;
        int rotation = e.getWheelRotation();
        int modifiers = e.getModifiers();
        boolean shiftDown = (modifiers & 1) != 0;
        boolean bl = ctrlDown = (modifiers & 2) != 0;
        if (!shiftDown && !ctrlDown) {
            HeatmapPosition pos = this.panel.getScrollPosition();
            this.panel.setScrollRowPosition(pos.row + rotation);
        } else {
            int height;
            int width = this.heatmap.getCellWidth() + rotation * -1;
            if (width < 1) {
                width = 1;
            }
            if ((height = this.heatmap.getCellHeight() + rotation * -1) < 1) {
                height = 1;
            }
            this.heatmap.setCellWidth(width);
            this.heatmap.setCellHeight(height);
        }
    }

    private void updateSelection(MouseEvent e) {
        this.point = e.getPoint();
        Point viewPosition = this.viewPort.getViewPosition();
        this.point.translate(viewPosition.x, viewPosition.y);
        this.coord = this.bodyPanel.getDrawer().getPosition(this.point);
        IMatrixView mv = this.heatmap.getMatrixView();
        mv.setLeadSelection(this.coord.row, this.coord.column);
        mv.setSelectedRows(new int[0]);
        mv.setSelectedColumns(new int[0]);
    }

    private void updateScroll(MouseEvent e, boolean dragging) {
        this.point = e.getPoint();
        if (!dragging) {
            this.startPoint = this.point;
            this.startScrollValue = this.panel.getScrollValue();
        } else {
            int widthOffset = this.point.x - this.startPoint.x;
            int heightOffset = this.point.y - this.startPoint.y;
            this.panel.setScrollColumnValue(this.startScrollValue.x - widthOffset);
            this.panel.setScrollRowValue(this.startScrollValue.y - heightOffset);
        }
    }

    private static enum Mode {
        none,
        selecting,
        moving;

    }
}

