/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.panel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.AbstractHeatmapDrawer;

public class AbstractHeatmapPanel
extends JPanel {
    protected Heatmap heatmap;
    protected AbstractHeatmapDrawer drawer;
    private final PropertyChangeListener heatmapListener;

    public AbstractHeatmapPanel(Heatmap heatmap, AbstractHeatmapDrawer drawer) {
        this.heatmap = heatmap;
        this.drawer = drawer;
        this.heatmapListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractHeatmapPanel.this.heatmapPropertyChanged(evt);
            }
        };
        this.updateSubscriptions(null);
        this.setPreferredSize(drawer.getSize());
        this.setBorder(null);
    }

    public Heatmap getHeatmap() {
        return this.heatmap;
    }

    public void setHeatmap(Heatmap heatmap) {
        Heatmap old = this.heatmap;
        this.heatmap = heatmap;
        this.drawer.setHeatmap(heatmap);
        this.updateSubscriptions(old);
        this.setPreferredSize(this.drawer.getSize());
    }

    public AbstractHeatmapDrawer getDrawer() {
        return this.drawer;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension size = this.drawer.getSize();
        Rectangle box = new Rectangle(0, 0, size.width, size.height);
        Rectangle clip = g.getClipBounds();
        this.drawer.draw((Graphics2D)g, box, clip);
    }

    private void updateSubscriptions(Heatmap old) {
        if (old != null) {
            old.removePropertyChangeListener(this.heatmapListener);
        }
        this.heatmap.addPropertyChangeListener(this.heatmapListener);
    }

    protected void heatmapPropertyChanged(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        Object src = evt.getSource();
        if (src.equals(this.heatmap)) {
            if ("cellSize".equals(pname)) {
                this.updateSize();
            }
        } else if (src.equals(this.heatmap.getMatrixView())) {
            if ("visibleColsChanged".equals(pname) || "visibleRowsChanged".equals(pname)) {
                this.updateSize();
            }
        } else if ((src.equals(this.heatmap.getRowDim()) || src.equals(this.heatmap.getColumnDim())) && ("headerSize".equals(pname) || "gridProperty".equals(pname))) {
            this.updateSize();
        }
        this.repaint();
    }

    public void updateSize() {
        this.setPreferredSize(this.drawer.getSize());
        this.revalidate();
    }
}

