/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.textlabels;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class TextLabelsSourcePage
extends AbstractWizardPage {
    protected HeatmapDim hdim;
    protected HeatmapTextLabelsHeader header;
    private JList annList;
    private JRadioButton annOpt;
    private JRadioButton idOpt;
    private JScrollPane jScrollPane1;
    private ButtonGroup optGroup;
    private JRadioButton patOpt;
    private JTextField pattText;

    public TextLabelsSourcePage(HeatmapDim hdim, HeatmapTextLabelsHeader header) {
        this.hdim = hdim;
        this.header = header;
        this.initComponents();
        ActionListener optionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextLabelsSourcePage.this.optionsChanged();
            }
        };
        this.idOpt.addActionListener(optionListener);
        this.annOpt.addActionListener(optionListener);
        this.patOpt.addActionListener(optionListener);
        this.setTitle("Select the contents of the header");
        this.setComplete(true);
    }

    public void updateControls() {
        super.updateControls();
        switch (this.header.getLabelSource()) {
            case ID: {
                this.idOpt.setSelected(true);
                break;
            }
            case ANNOTATION: {
                this.annOpt.setSelected(true);
                break;
            }
            case PATTERN: {
                this.patOpt.setSelected(true);
            }
        }
        AnnotationMatrix am = this.hdim.getAnnotations();
        if (am != null && am.getColumnCount() > 0) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = 0; i < am.getColumnCount(); ++i) {
                model.addElement(am.getColumnLabel(i));
            }
            this.annList.setModel(model);
            String label = this.header.getLabelAnnotation();
            int annIndex = am.getColumnIndex(label);
            if (annIndex > -1) {
                this.annList.setSelectedIndex(annIndex);
            }
        }
        this.pattText.setText(this.header.getLabelPattern());
        this.optionsChanged();
    }

    public void updateModel() {
        super.updateModel();
        this.header.setLabelSource(this.getLabelSource());
        this.header.setLabelAnnotation(this.getAnnotation());
        this.header.setLabelPattern(this.getPattern());
    }

    public HeatmapTextLabelsHeader.LabelSource getLabelSource() {
        if (this.idOpt.isSelected()) {
            return HeatmapTextLabelsHeader.LabelSource.ID;
        }
        if (this.annOpt.isSelected()) {
            return HeatmapTextLabelsHeader.LabelSource.ANNOTATION;
        }
        if (this.patOpt.isSelected()) {
            return HeatmapTextLabelsHeader.LabelSource.PATTERN;
        }
        return HeatmapTextLabelsHeader.LabelSource.ID;
    }

    private void optionsChanged() {
        this.annList.setEnabled(this.annOpt.isSelected());
        this.pattText.setEnabled(this.patOpt.isSelected());
    }

    public String getAnnotation() {
        if (this.annList.getSelectedIndex() != -1) {
            return (String)this.annList.getSelectedValue();
        }
        return "";
    }

    public String getPattern() {
        return this.pattText.getText();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.idOpt = new JRadioButton();
        this.annOpt = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.annList = new JList();
        this.patOpt = new JRadioButton();
        this.pattText = new JTextField();
        this.optGroup.add(this.idOpt);
        this.idOpt.setText("The ID");
        this.optGroup.add(this.annOpt);
        this.annOpt.setText("An annotation");
        this.annList.setSelectionMode(0);
        this.annList.setEnabled(false);
        this.jScrollPane1.setViewportView(this.annList);
        this.optGroup.add(this.patOpt);
        this.patOpt.setText("A pattern");
        this.pattText.setText("${id}");
        this.pattText.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jScrollPane1, -1, 462, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idOpt).addComponent(this.annOpt))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.pattText, -1, 462, Short.MAX_VALUE)).addComponent(this.patOpt)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.idOpt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.annOpt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 224, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.patOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pattText, -2, -1, -2).addContainerGap()));
    }
}

