/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.textlabels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.ui.platform.component.ColorChooserLabel;
import org.gitools.ui.platform.dialog.FontChooserDialog;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.FontUtils;

public class TextLabelsConfigPage
extends AbstractWizardPage {
    private HeatmapDim hdim;
    private HeatmapTextLabelsHeader header;
    private Font font;
    private ColorChooserLabel fgColor;
    private JButton fontBtn;
    private JTextField fontField;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public TextLabelsConfigPage(HeatmapDim hdim, HeatmapTextLabelsHeader header) {
        this.hdim = hdim;
        this.header = header;
        this.initComponents();
        this.fontBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextLabelsConfigPage.this.selectFont();
            }
        });
        this.setTitle("Header configuration");
        this.setComplete(true);
    }

    public void updateControls() {
        this.font = this.header.getFont();
        this.fontChanged();
        this.fgColor.setColor(this.header.getForegroundColor());
    }

    public void updateModel() {
        this.header.setFont(this.font);
        this.header.setForegroundColor(this.fgColor.getColor());
    }

    private void fontChanged() {
        this.fontField.setText(FontUtils.fontText(this.font));
        this.fontField.setFont(this.font);
    }

    private void selectFont() {
        FontChooserDialog dlg = new FontChooserDialog(null, this.header.getFont());
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.font = dlg.getFont();
        this.fontChanged();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.fontField = new JTextField();
        this.fontBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.fgColor = new ColorChooserLabel();
        this.jLabel2.setText("Font");
        this.fontField.setEditable(false);
        this.fontBtn.setText("...");
        this.jLabel1.setText("Color");
        this.fgColor.setColor(new Color(1, 1, 1));
        this.fgColor.setPreferredSize(new Dimension(28, 28));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontField, -1, 481, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontBtn)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fgColor, -2, 24, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fontField, -2, -1, -2).addComponent(this.fontBtn, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.fgColor, -2, 24, -2).addComponent(this.jLabel1)).addGap(318, 318, 318)));
    }
}

