/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.coloredlabels;

import java.awt.Container;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.gitools.clustering.HierarchicalClusteringResults;
import org.gitools.heatmap.header.HeatmapHierarchicalColoredLabelsHeader;
import org.gitools.newick.NewickTree;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class HclLevelPage
extends AbstractWizardPage {
    private HeatmapHierarchicalColoredLabelsHeader header;
    private JScrollPane jScrollPane1;
    private JList levels;

    public HclLevelPage(HeatmapHierarchicalColoredLabelsHeader header) {
        this.header = header;
        this.initComponents();
        DefaultListModel<String> model = new DefaultListModel<String>();
        HierarchicalClusteringResults hclResults = header.getClusteringResults();
        NewickTree tree = hclResults.getTree();
        int maxLevels = tree.getDepth() - 1;
        if (maxLevels < 1) {
            maxLevels = 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxLevels; ++i) {
            sb.append("Level ").append(i).append(": ");
            sb.append(tree.getRoot().getLeaves(i).size());
            sb.append(" clusters");
            model.addElement(sb.toString());
            sb.setLength(0);
        }
        this.levels.setModel(model);
        this.setTitle("Hierarchical clustering tree level");
        this.setComplete(true);
    }

    public void updateControls() {
        super.updateControls();
        this.levels.setSelectedIndex(this.header.getTreeLevel());
    }

    public int getLevel() {
        int level = this.levels.getSelectedIndex();
        if (level == -1) {
            level = 0;
        }
        return level;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.levels = new JList();
        this.levels.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.levels);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }
}

