/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.coloredlabels;

import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.clustering.method.annotations.AnnPatClusteringMethod;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class ColoredLabelsSourcePage
extends AbstractWizardPage {
    private HeatmapDim hdim;
    private AnnPatClusteringMethod method;
    private JList annList;
    private JRadioButton annOpt;
    private JComboBox annSepCb;
    private JLabel annSepLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ButtonGroup optGroup;
    private JRadioButton patOpt;
    private JTextField patText;

    public ColoredLabelsSourcePage(HeatmapDim hdim, AnnPatClusteringMethod method) {
        this.hdim = hdim;
        this.method = method;
        this.initComponents();
        ChangeListener optListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColoredLabelsSourcePage.this.sourceChanged();
            }
        };
        this.annOpt.addChangeListener(optListener);
        this.patOpt.addChangeListener(optListener);
        AnnotationMatrix am = hdim.getAnnotations();
        if (am != null && am.getColumnCount() > 0) {
            this.annOpt.setSelected(true);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = 0; i < am.getColumnCount(); ++i) {
                model.addElement(am.getColumnLabel(i));
            }
            this.annList.setModel(model);
            this.annList.setSelectedIndex(0);
        } else {
            this.patOpt.setSelected(true);
            this.annOpt.setEnabled(false);
        }
        this.annList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColoredLabelsSourcePage.this.updateCompleted();
            }
        });
        this.annSepCb.setModel(new DefaultComboBoxModel<String>(new String[]{", ", "-", " | ", " / ", " > ", "::"}));
        this.annSepCb.setSelectedIndex(0);
        this.patText.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                ColoredLabelsSourcePage.this.updateCompleted();
            }
        });
        this.setTitle("Annotations selection");
        this.setComplete(true);
    }

    private void updateCompleted() {
        boolean completed = this.annOpt.isSelected() && this.annList.getSelectedIndices().length > 0 || this.patOpt.isSelected() && this.patText.getDocument().getLength() > 0;
        this.setComplete(completed);
    }

    private void sourceChanged() {
        boolean annSel = this.annOpt.isSelected();
        this.annList.setEnabled(annSel);
        this.annSepLabel.setEnabled(annSel);
        this.annSepCb.setEnabled(annSel);
        this.patText.setEnabled(this.patOpt.isSelected());
    }

    public void updateModel() {
        super.updateModel();
        this.method.setPattern(this.getPattern());
    }

    public String getPattern() {
        if (this.patOpt.isSelected()) {
            return this.patText.getText();
        }
        AnnotationMatrix am = this.hdim.getAnnotations();
        StringBuilder sb = new StringBuilder();
        int[] indices = this.annList.getSelectedIndices();
        sb.append("${");
        sb.append(am.getColumnLabel(indices[0]));
        sb.append("}");
        for (int i = 1; i < indices.length; ++i) {
            sb.append(this.annSepCb.getSelectedItem());
            sb.append("${");
            sb.append(am.getColumnLabel(indices[i]));
            sb.append("}");
        }
        return sb.toString();
    }

    public String getClusterTitle() {
        if (this.patOpt.isSelected()) {
            return this.patText.getText();
        }
        AnnotationMatrix am = this.hdim.getAnnotations();
        StringBuilder sb = new StringBuilder();
        int[] indices = this.annList.getSelectedIndices();
        sb.append(am.getColumnLabel(indices[0]));
        for (int i = 1; i < indices.length; ++i) {
            sb.append(this.annSepCb.getSelectedItem());
            sb.append(am.getColumnLabel(indices[i]));
        }
        return sb.toString();
    }

    private void initComponents() {
        this.optGroup = new ButtonGroup();
        this.annOpt = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.annList = new JList();
        this.patOpt = new JRadioButton();
        this.patText = new JTextField();
        this.jLabel1 = new JLabel();
        this.annSepLabel = new JLabel();
        this.annSepCb = new JComboBox();
        this.optGroup.add(this.annOpt);
        this.annOpt.setText("Create labels by selecting a set of annotations");
        this.jScrollPane1.setViewportView(this.annList);
        this.optGroup.add(this.patOpt);
        this.patOpt.setText("Create labels by using a pattern");
        this.patText.setText("${id}");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 2.0f));
        this.jLabel1.setText("Press Ctrl key while selecting for multiple annotations");
        this.annSepLabel.setText("Separator");
        this.annSepCb.setEditable(true);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.patText, -2, 544, -2)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 544, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.annSepLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annSepCb, -2, 125, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annOpt)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.patOpt))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.annOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 153, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.annSepLabel).addComponent(this.annSepCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.patOpt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patText, -2, -1, -2).addContainerGap()));
    }
}

