/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.coloredlabels;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.method.annotations.AnnPatClusteringMethod;
import org.gitools.clustering.method.annotations.AnnPatColumnClusteringData;
import org.gitools.clustering.method.annotations.AnnPatRowClusteringData;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.heatmap.header.coloredlabels.ColoredLabelsConfigPage;
import org.gitools.ui.heatmap.header.coloredlabels.ColoredLabelsGroupsPage;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.wizard.common.PatternSourcePage;

public class ColoredLabelsHeaderWizard
extends AbstractWizard {
    private Heatmap heatmap;
    private HeatmapDim hdim;
    private boolean applyToRows;
    private boolean editionMode;
    private String lastPattern;
    private HeatmapColoredLabelsHeader header;
    private AnnPatClusteringMethod clusteringMethod;
    private PatternSourcePage sourcePage;
    private ColoredLabelsConfigPage headerPage;
    private ColoredLabelsGroupsPage clustersPage;

    public ColoredLabelsHeaderWizard(Heatmap heatmap, HeatmapDim hdim, HeatmapColoredLabelsHeader header, boolean applyToRows) {
        this.heatmap = heatmap;
        this.hdim = hdim;
        this.applyToRows = applyToRows;
        this.lastPattern = "";
        this.header = header;
        this.clusteringMethod = new AnnPatClusteringMethod();
    }

    public void addPages() {
        if (!this.editionMode) {
            this.sourcePage = new PatternSourcePage(this.hdim.getAnnotations(), true);
            this.addPage((IWizardPage)this.sourcePage);
        }
        this.headerPage = new ColoredLabelsConfigPage(this.header);
        this.addPage((IWizardPage)this.headerPage);
        this.clustersPage = new ColoredLabelsGroupsPage(this.header);
        this.addPage((IWizardPage)this.clustersPage);
    }

    public boolean canFinish() {
        return this.currentPage != this.sourcePage;
    }

    public void pageLeft(IWizardPage currentPage) {
        super.pageLeft(currentPage);
        if (currentPage != this.sourcePage || this.editionMode) {
            return;
        }
        String pattern = this.sourcePage.getPattern();
        if (this.lastPattern.equals(pattern)) {
            return;
        }
        IMatrixView mv = this.heatmap.getMatrixView();
        AnnotationMatrix am = this.hdim.getAnnotations();
        AnnPatRowClusteringData data = this.applyToRows ? new AnnPatRowClusteringData((IMatrix)mv, am, pattern) : new AnnPatColumnClusteringData((IMatrix)mv, am, pattern);
        this.header.setTitle("Colors: " + this.sourcePage.getPatternTitle());
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable((ClusteringData)data){
            final /* synthetic */ ClusteringData val$data;
            {
                this.val$data = clusteringData;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    ClusteringResults results = ColoredLabelsHeaderWizard.this.clusteringMethod.cluster(this.val$data, monitor);
                    ColoredLabelsHeaderWizard.this.header.updateFromClusterResults(results);
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }

    public HeatmapColoredLabelsHeader getHeader() {
        return this.header;
    }

    public void setEditionMode(boolean editionMode) {
        this.editionMode = editionMode;
    }
}

