/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.coloredlabels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.ui.platform.component.ColorChooserLabel;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class ColoredLabelsGroupsPage
extends AbstractWizardPage {
    private HeatmapColoredLabelsHeader header;
    private ColorChooserLabel clusterColor;
    private JList clusterList;
    private JTextField clusterName;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;

    public ColoredLabelsGroupsPage(HeatmapColoredLabelsHeader header) {
        this.header = header;
        this.initComponents();
        this.clusterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColoredLabelsGroupsPage.this.clusterSelectionChanged();
            }
        });
        this.clusterName.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                ColoredLabelsGroupsPage.this.clusterNameChanged();
            }
        });
        this.clusterColor.addColorChangeListener(new ColorChooserLabel.ColorChangeListener(){

            public void colorChanged(Color color) {
                ColoredLabelsGroupsPage.this.clusterColorChanged();
            }
        });
        this.setTitle("Labels configuration");
        this.setComplete(true);
    }

    public void updateControls() {
        super.updateControls();
        ClusterListModel clusterListModel = new ClusterListModel(this.header.getClusters());
        this.clusterList.setModel(clusterListModel);
        this.clusterSelectionChanged();
    }

    private void clusterSelectionChanged() {
        int index = this.clusterList.getSelectedIndex();
        boolean sel = index != -1;
        this.clusterName.setEnabled(sel);
        this.clusterColor.setEnabled(sel);
        if (sel) {
            HeatmapColoredLabelsHeader.ColoredLabel cluster = this.header.getClusters()[index];
            this.clusterName.setText(cluster.getName());
            this.clusterColor.setColor(cluster.getColor());
        }
    }

    private void clusterNameChanged() {
        int index = this.clusterList.getSelectedIndex();
        HeatmapColoredLabelsHeader.ColoredLabel cluster = this.header.getClusters()[index];
        cluster.setName(this.clusterName.getText());
    }

    private void clusterColorChanged() {
        int index = this.clusterList.getSelectedIndex();
        HeatmapColoredLabelsHeader.ColoredLabel cluster = this.header.getClusters()[index];
        cluster.setColor(this.clusterColor.getColor());
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.clusterList = new JList();
        this.jLabel6 = new JLabel();
        this.clusterName = new JTextField();
        this.jLabel7 = new JLabel();
        this.clusterColor = new ColorChooserLabel();
        this.jLabel5.setText("Labels");
        this.clusterList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.clusterList);
        this.jLabel6.setText("Name");
        this.jLabel7.setText("Color");
        this.clusterColor.setColor(new Color(1, 1, 1));
        this.clusterColor.setPreferredSize(new Dimension(28, 28));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 510, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clusterName, -1, 378, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.clusterColor, -2, 24, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 209, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.clusterName, -2, -1, -2).addComponent(this.jLabel7)).addComponent((Component)this.clusterColor, -2, 28, -2)).addContainerGap()));
    }

    private static class ClusterListModel
    implements ListModel {
        private HeatmapColoredLabelsHeader.ColoredLabel[] clusters;

        public ClusterListModel(HeatmapColoredLabelsHeader.ColoredLabel[] clusters) {
            this.clusters = clusters;
        }

        @Override
        public int getSize() {
            return this.clusters.length;
        }

        public Object getElementAt(int index) {
            return this.clusters[index];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

