/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.header.coloredlabels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.ui.platform.component.ColorChooserLabel;
import org.gitools.ui.platform.dialog.FontChooserDialog;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.FontUtils;

public class ColoredLabelsConfigPage
extends AbstractWizardPage {
    private HeatmapColoredLabelsHeader header;
    private Font labelFont;
    private ButtonGroup colorGroup;
    private JLabel fontLabel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private ColorChooserLabel labelColor;
    private JCheckBox labelColorDefinedChk;
    private JButton labelFontBtn;
    private JTextField labelFontField;
    private JCheckBox labelRotatedChk;
    private JCheckBox labelVisibleChk;
    private JSpinner marginSpin;
    private JCheckBox separationGridChk;
    private JSpinner thicknessSpin;
    private JTextField titleField;

    public ColoredLabelsConfigPage() {
        this(new HeatmapColoredLabelsHeader(null));
    }

    public ColoredLabelsConfigPage(HeatmapColoredLabelsHeader header) {
        this.header = header;
        this.initComponents();
        this.labelVisibleChk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColoredLabelsConfigPage.this.labelVisibleChanged();
            }
        });
        this.labelFontBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredLabelsConfigPage.this.selectFont();
            }
        });
        this.setTitle("Header configuration");
        this.setComplete(true);
    }

    public void updateControls() {
        super.updateControls();
        this.titleField.setText(this.header.getTitle());
        this.thicknessSpin.setValue(this.header.getThickness());
        this.marginSpin.setValue(this.header.getMargin());
        this.separationGridChk.setSelected(this.header.isSeparationGrid());
        this.labelVisibleChk.setSelected(this.header.isLabelVisible());
        this.labelFont = this.header.getLabelFont();
        this.fontChanged();
        this.labelRotatedChk.setSelected(this.header.isLabelRotated());
        this.labelColorDefinedChk.setSelected(this.header.isLabelColorDefined());
        this.labelColor.setColor(this.header.getLabelColor());
        this.labelVisibleChanged();
    }

    private void labelVisibleChanged() {
        boolean e = this.labelVisibleChk.isSelected();
        this.labelFontField.setEnabled(e);
        this.labelFontBtn.setEnabled(e);
        this.labelRotatedChk.setEnabled(e);
        this.labelColorDefinedChk.setEnabled(e);
        this.labelColor.setEnabled(this.labelColorDefinedChk.isSelected() && e);
    }

    private void fontChanged() {
        this.labelFontField.setText(FontUtils.fontText(this.labelFont));
        this.labelFontField.setFont(this.labelFont);
    }

    private void selectFont() {
        FontChooserDialog dlg = new FontChooserDialog(null, this.header.getLabelFont());
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.labelFont = dlg.getFont();
        this.fontChanged();
    }

    public void updateModel() {
        super.updateModel();
        this.header.setTitle(this.titleField.getText());
        this.header.setThickness(((Integer)this.thicknessSpin.getValue()).intValue());
        this.header.setMargin(((Integer)this.marginSpin.getValue()).intValue());
        this.header.setSeparationGrid(this.separationGridChk.isSelected());
        this.header.setLabelVisible(this.labelVisibleChk.isSelected());
        this.header.setLabelFont(this.labelFont);
        this.header.setLabelRotated(this.labelRotatedChk.isSelected());
        this.header.setLabelColorDefined(this.labelColorDefinedChk.isSelected());
        this.header.setLabelColor(this.labelColor.getColor());
    }

    private void initComponents() {
        this.colorGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.titleField = new JTextField();
        this.labelVisibleChk = new JCheckBox();
        this.fontLabel = new JLabel();
        this.labelFontField = new JTextField();
        this.labelFontBtn = new JButton();
        this.labelRotatedChk = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.thicknessSpin = new JSpinner();
        this.separationGridChk = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.marginSpin = new JSpinner();
        this.labelColor = new ColorChooserLabel();
        this.labelColorDefinedChk = new JCheckBox();
        this.jLabel1.setText("Title");
        this.labelVisibleChk.setText("Show cluster names");
        this.labelVisibleChk.setEnabled(false);
        this.fontLabel.setText("Font");
        this.fontLabel.setEnabled(false);
        this.labelFontField.setEditable(false);
        this.labelFontBtn.setText("...");
        this.labelRotatedChk.setText("Rotated text");
        this.jLabel4.setText("Thickness");
        this.jLabel4.setEnabled(false);
        this.thicknessSpin.setModel(new SpinnerNumberModel((Number)14, Integer.valueOf(0), null, (Number)1));
        this.thicknessSpin.setEnabled(false);
        this.separationGridChk.setText("Grid between different clusters");
        this.jLabel3.setText("Margin");
        this.marginSpin.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1));
        this.labelColor.setColor(new Color(1, 1, 1));
        this.labelColor.setPreferredSize(new Dimension(28, 28));
        this.labelColorDefinedChk.setText("All cluster names with the same color");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleField, -1, 587, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.marginSpin, -2, 64, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.thicknessSpin, -2, 64, -2)).addComponent(this.separationGridChk).addComponent(this.labelVisibleChk))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelRotatedChk).addGroup(layout.createSequentialGroup().addComponent(this.fontLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFontField, -1, 544, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFontBtn)).addGroup(layout.createSequentialGroup().addComponent(this.labelColorDefinedChk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.labelColor, -2, 24, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.titleField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.marginSpin, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.thicknessSpin, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.separationGridChk).addGap(18, 18, 18).addComponent(this.labelVisibleChk).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontLabel).addComponent(this.labelFontField, -2, -1, -2).addComponent(this.labelFontBtn, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.labelRotatedChk).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorDefinedChk).addComponent((Component)this.labelColor, -2, 24, -2)).addContainerGap()));
    }

    public HeatmapColoredLabelsHeader getHeader() {
        return this.header;
    }

    public void setHeader(HeatmapColoredLabelsHeader header) {
        this.header = header;
    }
}

