/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.editor;

import edu.upf.bg.colorscale.drawer.ColorScalePanel;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.IModel;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.actions.DataActions;
import org.gitools.ui.actions.EditActions;
import org.gitools.ui.actions.HeatmapActions;
import org.gitools.ui.heatmap.panel.HeatmapMouseListener;
import org.gitools.ui.heatmap.panel.HeatmapPanel;
import org.gitools.ui.heatmap.panel.search.HeatmapSearchPanel;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.ActionSet;
import org.gitools.ui.platform.actions.ActionSetUtils;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFileWizard;

public class HeatmapEditor
extends AbstractEditor {
    private static final long serialVersionUID = -540561086703759209L;
    private static final ActionSet toolBarAS = new ActionSet(new BaseAction[]{EditActions.selectAllAction, EditActions.unselectAllAction, BaseAction.separator, DataActions.hideSelectedColumnsAction, DataActions.showAllColumnsAction, DataActions.hideSelectedRowsAction, DataActions.showAllRowsAction, BaseAction.separator, DataActions.moveColsLeftAction, DataActions.moveColsRightAction, DataActions.moveRowsUpAction, DataActions.moveRowsDownAction, BaseAction.separator, DataActions.fastSortRowsAction, BaseAction.separator, HeatmapActions.cloneAction, HeatmapActions.searchAction});
    protected Heatmap heatmap;
    private HeatmapPanel heatmapPanel;
    private ColorScalePanel colorScalePanel;
    private HeatmapSearchPanel searchPanel;
    protected boolean blockSelectionUpdate;
    protected List<BaseAction> externalToolbarActions;
    private PropertyChangeListener heatmapListener;
    private PropertyChangeListener cellDecoratorListener;
    private PropertyChangeListener rowDecoratorListener;
    private PropertyChangeListener colDecoratorListener;
    protected final JPanel embeddedContainer;
    private int lastMouseRow = -1;
    private int lastMouseCol = -1;

    public HeatmapEditor(Heatmap heatmap) {
        this(heatmap, null, false);
    }

    public HeatmapEditor(Heatmap heatmap, List<BaseAction> externalToolbarActions) {
        this(heatmap, externalToolbarActions, false);
    }

    public HeatmapEditor(Heatmap heatmap, boolean embedded) {
        this(heatmap, toolBarAS.getActions(), embedded);
    }

    public HeatmapEditor(Heatmap heatmap, List<BaseAction> externalToolbarActions, boolean embedded) {
        this.heatmap = heatmap;
        this.externalToolbarActions = externalToolbarActions;
        IMatrixView matrixView = heatmap.getMatrixView();
        this.blockSelectionUpdate = false;
        this.embeddedContainer = embedded ? new JPanel() : this;
        this.createComponents(this.embeddedContainer);
        this.heatmapListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapEditor.this.heatmapPropertyChange(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.cellDecoratorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapEditor.this.colorScalePanel.update();
                HeatmapEditor.this.setDirty(true);
            }
        };
        this.rowDecoratorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapEditor.this.setDirty(true);
            }
        };
        this.colDecoratorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapEditor.this.setDirty(true);
            }
        };
        heatmap.addPropertyChangeListener(this.heatmapListener);
        heatmap.getActiveCellDecorator().addPropertyChangeListener(this.cellDecoratorListener);
        matrixView.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatmapEditor.this.matrixPropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.setSaveAsAllowed(true);
    }

    protected void heatmapPropertyChange(Object src, String pname, Object oldValue, Object newValue) {
        if (src.equals(this.heatmap)) {
            if ("cellDecorator".equals(pname)) {
                ElementDecorator prevDecorator = (ElementDecorator)oldValue;
                prevDecorator.removePropertyChangeListener(this.cellDecoratorListener);
                ElementDecorator nextDecorator = (ElementDecorator)newValue;
                nextDecorator.addPropertyChangeListener(this.cellDecoratorListener);
                this.colorScalePanel.setScale(nextDecorator.getScale());
            }
            if ("cellDecoratorSwitched".equals(pname)) {
                ElementDecorator nextDecorator = (ElementDecorator)newValue;
                this.colorScalePanel.setScale(nextDecorator.getScale());
            } else if ("propertyChanged".equals(pname)) {
                // empty if block
            }
        } else if (src instanceof HeatmapDim && "idType".equals(pname)) {
            this.refreshCellDetails();
        }
        this.setDirty(true);
    }

    protected void matrixPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("selectionLead".equals(propertyName)) {
            this.refreshCellDetails();
        } else if ("visibleColsChanged".equals(propertyName)) {
            this.setDirty(true);
        } else if ("visibleRowsChanged".equalsIgnoreCase(propertyName)) {
            this.setDirty(true);
        } else if (!"cellValueChanged".equals(propertyName) && "cellDecorationContextChanged".equals(propertyName)) {
            if (oldValue != null) {
                ((IModel)oldValue).removePropertyChangeListener(this.heatmapListener);
            }
            ((IModel)newValue).addPropertyChangeListener(this.heatmapListener);
            this.setDirty(true);
        }
    }

    private void refreshCellDetails() {
        AppFrame.instance().getDetailsView().updateContext(this.heatmap);
    }

    private void createComponents(JComponent container) {
        this.colorScalePanel = new ColorScalePanel(this.heatmap.getActiveCellDecorator().getScale());
        this.heatmapPanel = new HeatmapPanel(this.heatmap);
        this.heatmapPanel.requestFocusInWindow();
        this.heatmapPanel.addHeatmapMouseListener(new HeatmapMouseListener(){

            @Override
            public void mouseMoved(int row, int col, MouseEvent e) {
                HeatmapEditor.this.mouseMoved(row, col, e);
            }

            @Override
            public void mouseClicked(int row, int col, MouseEvent e) {
                HeatmapEditor.this.mouseClicked(row, col, e);
            }
        });
        ArrayList<BaseAction> actions = new ArrayList<BaseAction>(toolBarAS.getActions());
        if (this.externalToolbarActions != null) {
            actions.add(BaseAction.separator);
            actions.addAll(this.externalToolbarActions);
        }
        ActionSet as = new ActionSet(actions);
        JToolBar toolBar = ActionSetUtils.createToolBar((ActionSet)as);
        toolBar.setFloatable(false);
        this.searchPanel = new HeatmapSearchPanel(this.heatmap);
        this.searchPanel.setVisible(false);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)toolBar, "North");
        northPanel.add((Component)this.searchPanel, "South");
        container.setLayout(new BorderLayout());
        container.add((Component)northPanel, "North");
        container.add((Component)this.heatmapPanel, "Center");
        container.add((Component)this.colorScalePanel, "South");
    }

    public List<BaseAction> getExternalToolbarActions() {
        return this.externalToolbarActions;
    }

    protected IMatrixView getMatrixView() {
        return this.heatmap.getMatrixView();
    }

    public Object getModel() {
        return this.heatmap;
    }

    public void refresh() {
    }

    public void doVisible() {
        AppFrame.instance().setLeftPanelVisible(true);
        AppFrame.instance().getPropertiesView().updateContext(this.heatmap);
        this.refreshCellDetails();
        this.heatmapPanel.requestFocusInWindow();
    }

    public void doSave(IProgressMonitor monitor) {
        File file = this.getFile();
        if (file == null) {
            SaveFileWizard wiz = SaveFileWizard.createSimple("Save heatmap", this.getName(), Settings.getDefault().getLastPath(), new FileFormat[]{new FileFormat("Heatmap", "heatmap")});
            WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return;
            }
            Settings.getDefault().setLastPath(wiz.getFolder());
            file = wiz.getPathAsFile();
            this.setFile(file);
        }
        try {
            PersistenceManager.getDefault().store(file, this.getModel(), monitor);
        }
        catch (PersistenceException ex) {
            monitor.exception(ex);
        }
        this.setDirty(false);
    }

    public boolean doClose() {
        if (this.isDirty()) {
            int res = JOptionPane.showOptionDialog(AppFrame.instance(), "File " + this.getName() + " is modified.\n" + "Save changes ?", "Close", 1, 3, null, new String[]{"Cancel", "Discard", "Save"}, "Save");
            if (res == -1 || res == 0) {
                return false;
            }
            if (res == 2) {
                SaveFileWizard wiz = SaveFileWizard.createSimple("Save heatmap", this.getName(), Settings.getDefault().getLastPath(), new FileFormat[]{new FileFormat("Heatmap", "heatmap")});
                WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
                dlg.setVisible(true);
                if (dlg.isCancelled()) {
                    return false;
                }
                Settings.getDefault().setLastPath(wiz.getFolder());
                this.setFile(wiz.getPathAsFile());
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        HeatmapEditor.this.doSave(monitor);
                    }
                });
            }
        }
        return true;
    }

    public void setSearchVisible(boolean b) {
        this.searchPanel.setVisible(b);
    }

    protected void mouseMoved(int row, int col, MouseEvent e) {
        if (this.lastMouseRow == row && this.lastMouseCol == col) {
            return;
        }
        this.lastMouseRow = row;
        this.lastMouseCol = col;
        IMatrixView mv = this.heatmap.getMatrixView();
        StringBuilder sb = new StringBuilder();
        if (row != -1 && col == -1) {
            int annRow;
            String label = mv.getRowLabel(row);
            sb.append(label);
            AnnotationMatrix am = this.heatmap.getRowDim().getAnnotations();
            if (am != null && (annRow = am.getRowIndex(label)) != -1) {
                int annCount = am.getColumnCount();
                if (annCount > 0) {
                    sb.append(": ").append(am.getColumnLabel(0)).append(" = ").append(am.getCell(annRow, 0));
                }
                for (int annCol = 1; annCol < annCount; ++annCol) {
                    sb.append(", ").append(am.getColumnLabel(annCol)).append(" = ").append(am.getCell(annRow, annCol));
                }
            }
        } else if (row == -1 && col != -1) {
            int annRow;
            String label = mv.getColumnLabel(col);
            sb.append(label);
            AnnotationMatrix am = this.heatmap.getColumnDim().getAnnotations();
            if (am != null && (annRow = am.getRowIndex(label)) != -1) {
                int annCount = am.getColumnCount();
                if (annCount > 0) {
                    sb.append(": ").append(am.getColumnLabel(0)).append(" = ").append(am.getCell(annRow, 0));
                }
                for (int annCol = 1; annCol < annCount; ++annCol) {
                    sb.append(", ").append(am.getColumnLabel(annCol)).append(" = ").append(am.getCell(annRow, annCol));
                }
            }
        } else if (row != -1 && col != -1) {
            String rowLabel = mv.getRowLabel(row);
            String colLabel = mv.getColumnLabel(col);
            sb.append(colLabel).append(", ").append(rowLabel);
            List attrs = mv.getCellAttributes();
            if (attrs.size() > 0) {
                sb.append(": ").append(((IElementAttribute)attrs.get(0)).getName()).append(" = ").append(mv.getCellValue(row, col, 0));
                for (int i = 1; i < attrs.size(); ++i) {
                    sb.append(", ").append(((IElementAttribute)attrs.get(i)).getName()).append(" = ").append(mv.getCellValue(row, col, i));
                }
            }
        }
        if (sb.length() > 0) {
            AppFrame.instance().setStatusText(sb.toString());
        }
    }

    protected void mouseClicked(int row, int col, MouseEvent e) {
    }
}

