/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.editor;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectFactory2D;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import org.gitools.analysis.htest.HtestAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.ArrayElementAdapter;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorFactory;
import org.gitools.ui.heatmap.editor.HeatmapEditor;

public class HeatmapDemoEditor
extends HeatmapEditor {
    private static final long serialVersionUID = 2467164492764056062L;

    public HeatmapDemoEditor(int rows, int cols) {
        super(HeatmapDemoEditor.createModel(rows, cols));
        this.setName("Demo");
    }

    private static Heatmap createModel(int rows, int cols) {
        MatrixView matrixView = HeatmapDemoEditor.createTable(rows, cols);
        ElementDecorator decorator = ElementDecoratorFactory.create((String)"P-Value scale", (IElementAdapter)matrixView.getCellAdapter());
        return new Heatmap((IMatrixView)matrixView, decorator, new HeatmapTextLabelsHeader(), new HeatmapTextLabelsHeader());
    }

    private static MatrixView createTable(int rows, int cols) {
        int k = 0;
        DoubleMatrix1D values = DoubleFactory1D.dense.random(2 * rows * cols);
        ObjectMatrix2D data = ObjectFactory2D.dense.make(rows, cols);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                double[] v = new double[]{values.getQuick(k++), values.getQuick(k++)};
                data.setQuick(row, col, (Object)v);
            }
        }
        ObjectMatrix1D rowNames = ObjectFactory1D.dense.make(data.rows());
        for (int i = 0; i < rowNames.size(); ++i) {
            rowNames.setQuick(i, (Object)("row " + (i + 1)));
        }
        ObjectMatrix1D colNames = ObjectFactory1D.dense.make(data.columns());
        for (int i = 0; i < colNames.size(); ++i) {
            colNames.setQuick(i, (Object)("col " + (i + 1)));
        }
        ObjectMatrix resultsMatrix = new ObjectMatrix("Demo", rowNames, colNames, data, (IElementAdapter)new ArrayElementAdapter(new String[]{"p-value", "corrected-p-value"}));
        HtestAnalysis analysis = new HtestAnalysis();
        analysis.setResults(resultsMatrix);
        return new MatrixView((IMatrix)resultsMatrix);
    }
}

