/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.heatmap.editor;

import java.awt.event.ActionEvent;
import java.util.List;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.matrix.DiagonalMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.utils.SerialClone;

public class CloneHeatmapAction
extends BaseAction {
    public CloneHeatmapAction() {
        super("Clone heatmap");
        this.setDesc("Clone heatmap");
        this.setLargeIconFromResource("/img/CloneHeatmap24.gif");
    }

    public void actionPerformed(ActionEvent e) {
        EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        AbstractEditor currEd = editorPanel.getSelectedEditor();
        if (!(currEd instanceof HeatmapEditor)) {
            return;
        }
        HeatmapEditor currentEditor = (HeatmapEditor)currEd;
        Heatmap hm = (Heatmap)currentEditor.getModel();
        Object mv = hm.getMatrixView();
        mv = mv instanceof DiagonalMatrixView ? new DiagonalMatrixView(mv) : new MatrixView(mv);
        Heatmap clone = new Heatmap(mv);
        clone.setTitle(hm.getTitle());
        clone.setDescription(hm.getDescription());
        clone.setAttributes((List)SerialClone.xclone((Object)hm.getAttributes()));
        clone.setFooter(hm.getFooter());
        clone.setCellHeight(hm.getCellHeight());
        clone.setCellWidth(hm.getCellWidth());
        clone.setShowBorders(hm.isShowBorders());
        clone.setCellDecorators((ElementDecorator[])SerialClone.xclone((Object)hm.getCellDecorators()));
        clone.setColumnDim((HeatmapDim)SerialClone.xclone((Object)hm.getColumnDim()));
        clone.setRowDim((HeatmapDim)SerialClone.xclone((Object)hm.getRowDim()));
        HeatmapEditor editor = new HeatmapEditor(clone, currentEditor.getExternalToolbarActions());
        editor.setName(editorPanel.deriveName(currentEditor.getName(), "heatmap", "", "heatmap"));
        editorPanel.addEditor((AbstractEditor)editor);
    }
}

