/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.examples;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gitools.ui.settings.Settings;

public class ExamplesManager {
    private static ExamplesManager instance;
    private static final String EXAMPLES_BASE_URL = "http://webstart.gitools.org/default/examples";

    public static ExamplesManager getDefault() {
        if (instance == null) {
            instance = new ExamplesManager();
        }
        return instance;
    }

    private ExamplesManager() {
    }

    public File resolvePath(String exampleId, IProgressMonitor monitor) {
        String[] paths;
        int pos;
        File file = null;
        CodeSource sc = this.getClass().getProtectionDomain().getCodeSource();
        if (sc == null) {
            return this.resolveDownloadedPath(exampleId, monitor);
        }
        URL loc = sc.getLocation();
        if (!loc.getProtocol().equals("file")) {
            return this.resolveDownloadedPath(exampleId, monitor);
        }
        String locPath = loc.getPath();
        if (locPath.endsWith(".jar") && (pos = locPath.lastIndexOf(File.separatorChar)) >= 0) {
            locPath = locPath.substring(0, pos);
        }
        for (String path : paths = new String[]{"examples", "../examples", "../../examples", "../../../examples"}) {
            file = new File(locPath, path);
            if (!file.exists() || !(file = new File(file, exampleId)).exists()) continue;
            try {
                file = file.getCanonicalFile();
                return file;
            }
            catch (Exception ex) {
                file = null;
            }
        }
        return this.resolveDownloadedPath(exampleId, monitor);
    }

    private File resolveDownloadedPath(String exampleId, IProgressMonitor monitor) {
        File dstBasePath = new File(Settings.CONFIG_PATH + File.separator + "examples");
        if (!dstBasePath.exists()) {
            dstBasePath.mkdirs();
        }
        String srcTimestamp = this.getRemoteTimestamp(EXAMPLES_BASE_URL, exampleId, monitor);
        String dstTimestamp = "00000000000000";
        File examplePath = new File(dstBasePath, exampleId);
        if (examplePath.exists()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            dstTimestamp = sdf.format(new Date(examplePath.lastModified()));
        }
        if (srcTimestamp.compareTo(dstTimestamp) > 0) {
            this.downloadExample(dstBasePath, exampleId, monitor);
        }
        return examplePath;
    }

    private String getRemoteTimestamp(String srcBaseUrl, String exampleId, IProgressMonitor monitor) {
        try {
            URL url = new URL("http://webstart.gitools.org/default/examples/" + exampleId + ".timestamp");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String timestamp = reader.readLine();
            if (timestamp.length() < 14) {
                char[] fill = new char[timestamp.length() - 14];
                Arrays.fill(fill, '0');
                timestamp = timestamp + new String(fill);
            }
            return timestamp;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void downloadExample(File dstBasePath, String exampleId, IProgressMonitor monitor) {
        try {
            ZipEntry ze;
            monitor.begin("Downloading ...", 1);
            URL url = new URL("http://webstart.gitools.org/default/examples/" + exampleId + ".zip");
            ZipInputStream zin = new ZipInputStream(url.openStream());
            while ((ze = zin.getNextEntry()) != null) {
                IProgressMonitor mon = monitor.subtask();
                String name = ze.getName();
                mon.begin("Extracting " + name + " ...", (int)ze.getSize());
                File outFile = new File(dstBasePath, name);
                if (ze.isDirectory()) {
                    if (!outFile.exists()) {
                        outFile.mkdirs();
                    }
                } else {
                    int count;
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fout = new FileOutputStream(outFile);
                    int BUFFER_SIZE = 4096;
                    byte[] data = new byte[4096];
                    int partial = 0;
                    while ((count = zin.read(data, 0, 4096)) != -1) {
                        ((OutputStream)fout).write(data, 0, count);
                        mon.info((partial += count) / 1024 + " Kb read");
                        mon.worked(count);
                    }
                    ((OutputStream)fout).close();
                }
                zin.closeEntry();
                mon.end();
            }
            zin.close();
            monitor.end();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

