/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.dialog.filter;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.filter.MatrixViewLabelFilter;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.dialog.ExceptionDialog;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.PageDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.DocumentChangeListener;
import org.gitools.ui.utils.FileChooserUtils;
import org.gitools.ui.wizard.common.PatternSourcePage;

public class LabelFilterPage
extends AbstractWizardPage {
    private Heatmap hm;
    private String rowsPatt;
    private String colsPatt;
    private ButtonGroup applyGroup;
    private JButton colsPattBtn;
    private JTextField colsPattFld;
    private JRadioButton colsRb;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JButton loadBtn;
    private JTextArea patterns;
    private JButton rowsPattBtn;
    private JTextField rowsPattFld;
    private JRadioButton rowsRb;
    private JButton saveBtn;
    private JCheckBox useRegexCheck;

    public LabelFilterPage(Heatmap hm) {
        this.hm = hm;
        this.initComponents();
        ActionListener dimChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelFilterPage.this.dimChanged();
            }
        };
        this.rowsRb.addActionListener(dimChangedListener);
        this.colsRb.addActionListener(dimChangedListener);
        this.rowsPattBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelFilterPage.this.selectRowsPattern();
            }
        });
        this.colsPattBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LabelFilterPage.this.selectColsPattern();
            }
        });
        this.patterns.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                LabelFilterPage.this.saveBtn.setEnabled(LabelFilterPage.this.patterns.getDocument().getLength() > 0);
            }
        });
        this.rowsPatt = "${id}";
        this.rowsPattFld.setText("id");
        this.colsPatt = "${id}";
        this.colsPattFld.setText("id");
        this.dimChanged();
        this.setTitle("Filter by label");
        this.setComplete(true);
    }

    private void dimChanged() {
        boolean rs = this.rowsRb.isSelected();
        this.rowsPattFld.setEnabled(rs);
        this.rowsPattBtn.setEnabled(rs);
        boolean cs = this.colsRb.isSelected();
        this.colsPattFld.setEnabled(cs);
        this.colsPattBtn.setEnabled(cs);
    }

    protected String readNamesFromFile(File file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void selectRowsPattern() {
        PatternSourcePage page = new PatternSourcePage(this.hm.getRowDim().getAnnotations(), true);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.rowsPatt = page.getPattern();
        this.rowsPattFld.setText(page.getPatternTitle());
    }

    private void selectColsPattern() {
        PatternSourcePage page = new PatternSourcePage(this.hm.getColumnDim().getAnnotations(), true);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        this.colsPatt = page.getPattern();
        this.colsPattFld.setText(page.getPatternTitle());
    }

    public MatrixViewLabelFilter.FilterDimension getFilterDimension() {
        if (this.rowsRb.isSelected()) {
            return MatrixViewLabelFilter.FilterDimension.ROWS;
        }
        return MatrixViewLabelFilter.FilterDimension.COLUMNS;
    }

    public String getPattern() {
        if (this.rowsRb.isSelected()) {
            return this.rowsPatt;
        }
        return this.colsPatt;
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        StringReader sr = new StringReader(this.patterns.getText());
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                values.add(line);
            }
        }
        catch (IOException ex) {
            ExceptionDialog dlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            dlg.setVisible(true);
        }
        return values;
    }

    public boolean isUseRegexChecked() {
        return this.useRegexCheck.isSelected();
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.useRegexCheck = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.patterns = new JTextArea();
        this.jLabel3 = new JLabel();
        this.loadBtn = new JButton();
        this.rowsPattFld = new JTextField();
        this.saveBtn = new JButton();
        this.rowsPattBtn = new JButton();
        this.colsPattFld = new JTextField();
        this.colsPattBtn = new JButton();
        this.rowsRb = new JRadioButton();
        this.colsRb = new JRadioButton();
        this.jLabel1.setText("Labels to include:");
        this.useRegexCheck.setText("Use regular expressions");
        this.patterns.setColumns(20);
        this.patterns.setRows(6);
        this.jScrollPane1.setViewportView(this.patterns);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont((float)this.jLabel3.getFont().getSize() - 2.0f));
        this.jLabel3.setText("One label or regular expression per line");
        this.loadBtn.setText("Load...");
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelFilterPage.this.loadBtnActionPerformed(evt);
            }
        });
        this.rowsPattFld.setEditable(false);
        this.saveBtn.setText("Save...");
        this.saveBtn.setEnabled(false);
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelFilterPage.this.saveBtnActionPerformed(evt);
            }
        });
        this.rowsPattBtn.setText("Change...");
        this.colsPattFld.setEditable(false);
        this.colsPattBtn.setText("Change...");
        this.applyGroup.add(this.rowsRb);
        this.rowsRb.setSelected(true);
        this.rowsRb.setText("Rows");
        this.applyGroup.add(this.colsRb);
        this.colsRb.setText("Columns");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colsRb).addComponent(this.rowsRb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.rowsPattFld, -1, 341, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsPattBtn)).addGroup(layout.createSequentialGroup().addComponent(this.colsPattFld, -1, 341, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colsPattBtn)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 434, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.saveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.loadBtn, -2, 78, -2))).addComponent(this.jLabel3).addComponent(this.useRegexCheck)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rowsPattBtn).addComponent(this.rowsRb).addComponent(this.rowsPattFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colsPattBtn).addComponent(this.colsRb).addComponent(this.colsPattFld, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loadBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn)).addComponent(this.jScrollPane1, -2, 175, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.useRegexCheck).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadBtnActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooserUtils.selectFile("Select the file containing values", Settings.getDefault().getLastFilterPath(), 2);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastFilterPath(file.getParent());
            this.patterns.setText(this.readNamesFromFile(file));
        }
        catch (IOException ex) {
            ExceptionDialog edlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooserUtils.selectFile("Select file name ...", Settings.getDefault().getLastFilterPath(), 1);
            if (file == null) {
                return;
            }
            Settings.getDefault().setLastFilterPath(file.getParent());
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.append(this.patterns.getText()).append('\n');
            bw.close();
        }
        catch (Exception ex) {
            ExceptionDialog edlg = new ExceptionDialog((Window)AppFrame.instance(), (Throwable)ex);
            edlg.setVisible(true);
        }
    }
}

