/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.dialog.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AttributesSelectionModel<T>
implements ListModel {
    private T[] attributes;
    private List<Integer> selectedAttributes;
    private List<Integer> unselectedAttributes;
    private List<ListDataListener> listeners;

    public AttributesSelectionModel(T[] attributes) {
        this.attributes = attributes;
        this.selectedAttributes = new ArrayList<Integer>();
        this.unselectedAttributes = new ArrayList<Integer>();
        this.listeners = new ArrayList<ListDataListener>();
        for (int i = 0; i < attributes.length; ++i) {
            this.selectedAttributes.add(i);
        }
    }

    @Override
    public int getSize() {
        return this.selectedAttributes.size();
    }

    public Object getElementAt(int index) {
        return this.attributes[this.selectedAttributes.get(index)];
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public T[] getAttributes() {
        return this.attributes;
    }

    public List<Integer> getSelectedIndices() {
        return Collections.unmodifiableList(this.selectedAttributes);
    }

    public void setSelectedIndices(List<Integer> indices) {
        ArrayList<Integer> unselectAttributes = new ArrayList<Integer>(this.selectedAttributes);
        this.unselect(unselectAttributes);
        this.select(indices);
    }

    public List<Integer> getUnselectedIndices() {
        return Collections.unmodifiableList(this.unselectedAttributes);
    }

    public List<T> getSelectedAttributes() {
        ArrayList<T> attr = new ArrayList<T>(this.selectedAttributes.size());
        for (int i = 0; i < this.selectedAttributes.size(); ++i) {
            attr.add(this.attributes[this.selectedAttributes.get(i)]);
        }
        return attr;
    }

    public List<T> getUnselectedAttributes() {
        ArrayList<T> attr = new ArrayList<T>(this.unselectedAttributes.size());
        for (int i = 0; i < this.unselectedAttributes.size(); ++i) {
            attr.add(this.attributes[this.unselectedAttributes.get(i)]);
        }
        return attr;
    }

    public void select(List<Integer> indices) {
        for (Integer i : indices) {
            if (!this.unselectedAttributes.contains(i)) continue;
            this.unselectedAttributes.remove(i);
            this.selectedAttributes.add(i);
        }
        this.fireChange();
    }

    public void unselect(List<Integer> indices) {
        for (Integer i : indices) {
            if (!this.selectedAttributes.contains(i)) continue;
            this.selectedAttributes.remove(i);
            this.unselectedAttributes.add(i);
        }
        this.fireChange();
    }

    public void moveUp(List<Integer> indices) {
        for (Integer index : indices) {
            int i = this.selectedAttributes.indexOf(index);
            if (i < 0) continue;
            Integer tmp = this.selectedAttributes.get(i);
            this.selectedAttributes.set(i, this.selectedAttributes.get(i - 1));
            this.selectedAttributes.set(i - 1, tmp);
        }
        this.fireChange();
    }

    public void moveDown(List<Integer> indices) {
        for (Integer index : indices) {
            int i = this.selectedAttributes.indexOf(index);
            if (i < 0) continue;
            Integer tmp = this.selectedAttributes.get(i);
            this.selectedAttributes.set(i, this.selectedAttributes.get(i + 1));
            this.selectedAttributes.set(i + 1, tmp);
        }
        this.fireChange();
    }

    private void fireChange() {
        int size = this.selectedAttributes.size();
        ListDataEvent e = new ListDataEvent(this, 0, 0, size > 0 ? size - 1 : 0);
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(e);
        }
    }
}

